/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi.impl.jcr10.constraint;

import com.day.jcr.vault.fs.spi.impl.jcr10.constraint.BooleanConstraint;
import com.day.jcr.vault.fs.spi.impl.jcr10.constraint.DateConstraint;
import com.day.jcr.vault.fs.spi.impl.jcr10.constraint.NameConstraint;
import com.day.jcr.vault.fs.spi.impl.jcr10.constraint.NumericConstraint;
import com.day.jcr.vault.fs.spi.impl.jcr10.constraint.PathConstraint;
import com.day.jcr.vault.fs.spi.impl.jcr10.constraint.ReferenceConstraint;
import com.day.jcr.vault.fs.spi.impl.jcr10.constraint.StringConstraint;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValueConstraint {
    protected static Logger log = LoggerFactory.getLogger(ValueConstraint.class);
    public static final ValueConstraint[] EMPTY_ARRAY = new ValueConstraint[0];
    static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    private final String definition;

    protected ValueConstraint(String definition) {
        this.definition = definition;
    }

    public String getDefinition(NamePathResolver resolver) {
        return this.definition;
    }

    public String getString() {
        return this.definition;
    }

    public String toString() {
        return this.getString();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof ValueConstraint && this.definition.equals(((ValueConstraint)other).definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public static ValueConstraint create(int type, String definition) throws InvalidConstraintException {
        if (definition == null) {
            throw new IllegalArgumentException("illegal definition (null)");
        }
        switch (type) {
            case 1: {
                return new StringConstraint(definition);
            }
            case 6: {
                return new BooleanConstraint(definition);
            }
            case 2: {
                return new NumericConstraint(definition);
            }
            case 5: {
                return new DateConstraint(definition);
            }
            case 3: 
            case 4: {
                return new NumericConstraint(definition);
            }
            case 7: {
                return NameConstraint.create(definition);
            }
            case 8: {
                return PathConstraint.create(definition);
            }
            case 9: {
                return ReferenceConstraint.create(definition);
            }
        }
        throw new IllegalArgumentException("unknown/unsupported target type for constraint: " + PropertyType.nameFromValue((int)type));
    }

    public static ValueConstraint[] create(int type, String[] definition) throws InvalidConstraintException {
        if (definition == null || definition.length == 0) {
            return EMPTY_ARRAY;
        }
        ValueConstraint[] ret = new ValueConstraint[definition.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueConstraint.create(type, definition[i]);
        }
        return ret;
    }

    public static ValueConstraint[] create(int type, String[] jcrDefinition, NamePathResolver resolver) throws InvalidConstraintException {
        if (jcrDefinition == null || jcrDefinition.length == 0) {
            return EMPTY_ARRAY;
        }
        ValueConstraint[] ret = new ValueConstraint[jcrDefinition.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueConstraint.create(type, jcrDefinition[i], resolver);
        }
        return ret;
    }

    public static ValueConstraint create(int type, String jcrDefinition, NamePathResolver resolver) throws InvalidConstraintException {
        if (jcrDefinition == null) {
            throw new IllegalArgumentException("Illegal definition (null) for ValueConstraint.");
        }
        switch (type) {
            case 1: {
                return new StringConstraint(jcrDefinition);
            }
            case 6: {
                return new BooleanConstraint(jcrDefinition);
            }
            case 2: {
                return new NumericConstraint(jcrDefinition);
            }
            case 5: {
                return new DateConstraint(jcrDefinition);
            }
            case 3: 
            case 4: {
                return new NumericConstraint(jcrDefinition);
            }
            case 7: {
                return NameConstraint.create(jcrDefinition, (NameResolver)resolver);
            }
            case 8: {
                return PathConstraint.create(jcrDefinition, (PathResolver)resolver);
            }
            case 9: {
                return ReferenceConstraint.create(jcrDefinition, (NameResolver)resolver);
            }
        }
        throw new IllegalArgumentException("Unknown/unsupported target type for constraint: " + PropertyType.nameFromValue((int)type));
    }
}

