/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.packaging.InstallContext;
import com.day.jcr.vault.packaging.InstallHook;
import com.day.jcr.vault.packaging.PackageException;
import com.day.jcr.vault.packaging.impl.InstallContextImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallHookProcessor {
    private static final Logger log = LoggerFactory.getLogger(InstallHookProcessor.class);
    private final TreeMap<String, Hook> hooks = new TreeMap();

    public void registerHooks(Archive archive) throws PackageException {
        try {
            Archive.Entry root = archive.getRoot();
            root = root.getChild("META-INF");
            if (root == null) {
                log.warn("Archive {} does not have a {} directory.", (Object)archive, (Object)"META-INF");
                return;
            }
            if ((root = root.getChild("vault")) == null) {
                log.warn("Archive {} does not have a {} directory.", (Object)archive, (Object)"vault");
                return;
            }
            if ((root = root.getChild("hooks")) == null) {
                log.info("Archive {} does not have a {} directory.", (Object)archive, (Object)"hooks");
                return;
            }
            for (Archive.Entry entry : root.getChildren()) {
                if (!entry.getName().endsWith(".jar")) continue;
                this.registerHook(archive.getInputSource(entry));
            }
        }
        catch (IOException e) {
            throw new PackageException("I/O Error while registering hooks", e);
        }
    }

    public void registerHook(VaultInputSource input) throws IOException, PackageException {
        File jarFile = File.createTempFile("vaulthook", ".jar");
        Hook hook = new Hook(input.getSystemId(), jarFile);
        FileOutputStream out = null;
        InputStream in = input.getByteStream();
        try {
            out = FileUtils.openOutputStream((File)jarFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            hook.destroy();
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        try {
            hook.init();
        }
        catch (IOException e) {
            hook.destroy();
            throw e;
        }
        catch (PackageException e) {
            hook.destroy();
            throw e;
        }
        this.hooks.put(hook.name, hook);
        log.info("Hook {} registered.", (Object)hook.name);
    }

    public boolean hasHooks() {
        return !this.hooks.isEmpty();
    }

    public boolean execute(InstallContextImpl context) {
        for (Hook hook : this.hooks.values()) {
            try {
                hook.getHook().execute(context);
            }
            catch (PackageException e) {
                if (context.getPhase() == InstallContext.Phase.PREPARE) {
                    log.info("Hook " + hook.name + " threw package exception. Prepare aborted.", (Throwable)e);
                    context.setPhase(InstallContext.Phase.PREPARE_FAILED);
                    this.execute(context);
                    return false;
                }
                log.info("Hook " + hook.name + " threw package exception. Ignored", (Throwable)e);
            }
            catch (Throwable e) {
                log.info("Hook " + hook.name + " threw runtime exception.", e);
            }
            if (context.getPhase() != InstallContext.Phase.END) continue;
            hook.destroy();
        }
        return true;
    }

    private static class Hook {
        private final String name;
        private final File jarFile;
        private URLClassLoader classLoader;
        private InstallHook hook;

        private Hook(String name, File jarFile) {
            this.name = name;
            this.jarFile = jarFile;
        }

        private void destroy() {
            this.classLoader = null;
            this.hook = null;
            FileUtils.deleteQuietly((File)this.jarFile);
        }

        private void init() throws IOException, PackageException {
            Class<?> clazz;
            JarFile jar = new JarFile(this.jarFile);
            Manifest mf = jar.getManifest();
            if (mf == null) {
                throw new PackageException("hook jar file does not have a manifest: " + this.name);
            }
            String mainClassName = mf.getMainAttributes().getValue("Main-Class");
            if (mainClassName == null) {
                throw new PackageException("hook manifest file does not have a Main-Class entry: " + this.name);
            }
            log.info("Hook {}: Main-Class = {}", (Object)this.name, (Object)mainClassName);
            if (this.classLoader == null) {
                this.classLoader = URLClassLoader.newInstance(new URL[]{this.jarFile.toURL()}, this.getClass().getClassLoader());
            }
            try {
                clazz = this.classLoader.loadClass(mainClassName);
            }
            catch (ClassNotFoundException e) {
                throw new PackageException("hook main class " + mainClassName + " not found: " + this.name, e);
            }
            if (!InstallHook.class.isAssignableFrom(clazz)) {
                throw new PackageException("hook main class " + mainClassName + " does not implement the InstallHook interface: " + this.name);
            }
            try {
                this.hook = (InstallHook)clazz.newInstance();
            }
            catch (Exception e) {
                throw new PackageException("hook main class " + mainClassName + " could not be instantiated.", e);
            }
        }

        public InstallHook getHook() {
            return this.hook;
        }
    }
}

