/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.fs.api.ImportMode;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.packaging.ExportOptions;
import com.day.jcr.vault.packaging.ImportOptions;
import com.day.jcr.vault.packaging.JcrPackage;
import com.day.jcr.vault.packaging.JcrPackageDefinition;
import com.day.jcr.vault.packaging.PackageException;
import com.day.jcr.vault.packaging.PackageId;
import com.day.jcr.vault.packaging.VaultPackage;
import com.day.jcr.vault.packaging.impl.InstallContextImpl;
import com.day.jcr.vault.packaging.impl.JcrPackageDefinitionImpl;
import com.day.jcr.vault.packaging.impl.JcrPackageManagerImpl;
import com.day.jcr.vault.packaging.impl.ZipVaultPackage;
import com.day.jcr.vault.util.Text;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageImpl
implements JcrPackage {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageImpl.class);
    private Node node;
    private ZipVaultPackage pack;
    private JcrPackageDefinitionImpl def;

    public JcrPackageImpl(Node node) throws RepositoryException {
        this.node = node;
    }

    protected JcrPackageImpl(Node node, ZipVaultPackage pack) throws RepositoryException {
        this.node = node;
        this.pack = pack;
    }

    protected JcrPackageImpl(Node node, ZipVaultPackage pack, JcrPackageDefinitionImpl def) throws RepositoryException {
        this.node = node;
        this.pack = pack;
        this.def = def;
    }

    public JcrPackageDefinition getDefinition() throws RepositoryException {
        if (this.def == null && this.isValid()) {
            Node defNode = this.getDefNode();
            this.def = defNode == null ? null : new JcrPackageDefinitionImpl(defNode);
        }
        return this.def;
    }

    public int compareTo(JcrPackage o) {
        try {
            JcrPackageDefinition d1 = this.getDefinition();
            JcrPackageDefinition d2 = o.getDefinition();
            return d1.getId().compareTo(d2.getId());
        }
        catch (Exception e) {
            log.error("error during compare: {}", (Object)e.toString());
            return 0;
        }
    }

    public boolean isValid() {
        try {
            if (this.node != null && this.node.isNodeType("nt:hierarchyNode") && this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").isNodeType("vlt:Package")) {
                return true;
            }
        }
        catch (RepositoryException e) {
            log.warn("Error during evaluation of isValid()", (Throwable)e);
        }
        return false;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isSealed() {
        try {
            if (!this.isValid()) {
                return false;
            }
            if (this.getSize() == 0L) {
                return false;
            }
            if (this.getDefinition() == null) {
                return true;
            }
            return !this.def.isModified();
        }
        catch (RepositoryException e) {
            log.warn("Error during isSealed()", (Throwable)e);
            return false;
        }
    }

    public static JcrPackage createNew(Node parent, String name, VaultPackage pack) throws RepositoryException, IOException {
        return JcrPackageImpl.createNew(parent, name, pack, true);
    }

    public static JcrPackage createNew(Node parent, String name, VaultPackage pack, boolean autoSave) throws RepositoryException, IOException {
        return JcrPackageImpl.createNew(parent, name, null, pack, autoSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JcrPackage createNew(Node parent, String name, String version, VaultPackage pack, boolean autoSave) throws RepositoryException, IOException {
        Node node = parent.addNode(name, "nt:file");
        Node content = node.addNode("jcr:content", "nt:resource");
        content.addMixin("vlt:Package");
        Node defNode = content.addNode("vlt:definition");
        JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
        if (version != null && version.length() > 0) {
            def.set("version", version, false);
        }
        def.touch(null, false);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:mimeType", "application/zip");
        InputStream in = new ByteArrayInputStream(new byte[0]);
        try {
            if (pack != null && pack.getFile() != null) {
                in = FileUtils.openInputStream((File)pack.getFile());
            }
            content.setProperty("jcr:data", in);
            if (pack != null) {
                def.unwrap(pack, true, false);
            }
            if (autoSave) {
                parent.save();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new JcrPackageImpl(node, (ZipVaultPackage)pack);
    }

    public boolean verifyId(boolean autoFix, boolean autoSave) throws RepositoryException {
        PackageId cId;
        JcrPackageDefinition jDef = this.getDefinition();
        if (jDef == null) {
            return true;
        }
        PackageId id = jDef.getId();
        if (id.equals(cId = new PackageId(this.node.getPath()))) {
            if (autoFix && id.isFromPath()) {
                jDef.setId(cId, autoSave);
            }
            return true;
        }
        if (autoFix) {
            log.warn("Fixing non-matching id from {} to {}.", (Object)id, (Object)cId);
            jDef.setId(cId, autoSave);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryUnwrap() throws IOException, RepositoryException {
        if (this.isValid()) {
            return;
        }
        VaultPackage pack = this.getPackage();
        Node content = this.getContent();
        boolean ok = false;
        try {
            content.addMixin("vlt:Package");
            Node defNode = content.addNode("vlt:definition");
            JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
            def.unwrap(pack, true, false);
            this.node.save();
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    this.node.refresh(false);
                }
                catch (RepositoryException e) {}
            }
        }
    }

    public VaultPackage getPackage() throws RepositoryException, IOException {
        if (this.pack == null) {
            File tmpFile = File.createTempFile("vaultpack", ".zip");
            FileOutputStream out = FileUtils.openOutputStream((File)tmpFile);
            InputStream in = this.getData().getStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            this.pack = new ZipVaultPackage(tmpFile, true);
        }
        return this.pack;
    }

    public void extract(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        this.extract(opts, false, false);
    }

    public void install(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        this.extract(opts, true, false);
    }

    private void extract(ImportOptions opts, boolean createSnapshot, boolean replaceSnapshot) throws RepositoryException, PackageException, IOException {
        this.getPackage();
        InstallContextImpl ctx = this.pack.prepareExtract(this.node.getSession(), opts);
        if (!opts.isDryRun() && createSnapshot) {
            ExportOptions eOpts = new ExportOptions();
            eOpts.setListener(opts.getListener());
            this.snapshot(eOpts, replaceSnapshot);
        }
        ArrayList<String> subPackages = new ArrayList<String>();
        this.pack.extract(ctx, subPackages);
        this.getDefinition();
        if (this.def != null && !opts.isDryRun()) {
            this.def.touchLastUnpacked(null, true);
        }
        if (opts.isNonRecursive()) {
            return;
        }
        Session s = this.node.getSession();
        for (String path : subPackages) {
            if (!s.itemExists(path)) continue;
            JcrPackageImpl p = new JcrPackageImpl((Node)s.getItem(path));
            if (!p.isValid()) {
                try {
                    p.tryUnwrap();
                }
                catch (Exception e) {
                    log.info("Sub package {} not valid: " + e, (Object)path);
                }
            }
            if (!p.isValid()) continue;
            String msg = "Starting extraction of subpackage " + path;
            if (opts.isDryRun()) {
                msg = "Dry run: " + msg;
            }
            if (opts.getListener() != null) {
                opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, msg, "");
            } else {
                log.info(msg);
            }
            p.extract(opts, createSnapshot, true);
            p.close();
        }
    }

    public JcrPackage snapshot(ExportOptions opts, boolean replace) throws RepositoryException, PackageException, IOException {
        PackageId id = this.getSnapshotId();
        if (this.node.getSession().itemExists(id.getInstallationPath())) {
            if (!replace) {
                log.warn("Refusing to recreate snapshot {}, already exists.", (Object)id);
                return null;
            }
            Node packNode = (Node)this.node.getSession().getItem(id.getInstallationPath());
            packNode.remove();
            this.node.getSession().save();
        }
        JcrPackageManagerImpl packMgr = new JcrPackageManagerImpl(this.node.getSession());
        String path = id.getInstallationPath();
        String parentPath = Text.getRelativeParent(path, 1);
        Node folder = packMgr.mkdir(parentPath, true);
        JcrPackage snap = JcrPackageImpl.createNew(folder, id.getName(), null);
        JcrPackageDefinitionImpl snapDef = (JcrPackageDefinitionImpl)snap.getDefinition();
        JcrPackageDefinitionImpl myDef = (JcrPackageDefinitionImpl)this.getDefinition();
        snapDef.setId(id, false);
        snapDef.setFilter(myDef.getMetaInf().getFilter(), false);
        snapDef.set("jcr:description", "Snapshot of package " + myDef.getId().toString(), false);
        snapDef.set("acHandling", myDef.get("acHandling"), false);
        if (opts.getListener() != null) {
            opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, "Creating snapshot for package " + myDef.getId(), "");
        }
        packMgr.assemble(snap.getNode(), snapDef, opts.getListener());
        return snap;
    }

    public JcrPackage getSnapshot() throws RepositoryException {
        Node packNode;
        JcrPackageImpl snap;
        PackageId id = this.getSnapshotId();
        if (this.node.getSession().itemExists(id.getInstallationPath()) && (snap = new JcrPackageImpl(packNode = (Node)this.node.getSession().getItem(id.getInstallationPath()))).isValid()) {
            return snap;
        }
        return null;
    }

    private PackageId getSnapshotId() throws RepositoryException {
        PackageId id = this.getDefinition().getId();
        String group = id.getGroup();
        group = group.length() == 0 ? ".snapshot" : group + "/.snapshot";
        return new PackageId(group, id.getName(), id.getVersion());
    }

    public void uninstall(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        JcrPackage snap = this.getSnapshot();
        if (snap == null) {
            throw new PackageException("Unable to uninstall package. No snapshot present.");
        }
        if (opts.getListener() != null) {
            opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, "Uninstalling package from snapshot " + snap.getDefinition().getId(), "");
        }
        Session s = this.getNode().getSession();
        opts.setImportMode(ImportMode.REPLACE);
        snap.extract(opts);
        snap.getNode().remove();
        s.save();
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)this.getDefinition();
        def.clearLastUnpacked(true);
    }

    public long getSize() {
        try {
            this.assertValid();
            return this.getData().getLength();
        }
        catch (RepositoryException e) {
            log.error("Error during getSize()", (Throwable)e);
            return -1L;
        }
    }

    public void close() {
        this.node = null;
        if (this.pack != null) {
            this.pack.close();
            this.pack = null;
        }
    }

    private Node getContent() throws RepositoryException {
        return this.node.getNode("jcr:content");
    }

    public Property getData() throws RepositoryException {
        return this.getContent().getProperty("jcr:data");
    }

    public Node getDefNode() throws RepositoryException {
        Node content = this.getContent();
        return content.hasNode("vlt:definition") ? content.getNode("vlt:definition") : null;
    }

    private void assertValid() throws RepositoryException {
        if (!this.isValid()) {
            throw new IllegalArgumentException("not a valid package.");
        }
    }
}

