/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.fs.Mounter;
import com.day.jcr.vault.fs.api.RepositoryAddress;
import com.day.jcr.vault.fs.api.VaultFileSystem;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.fs.io.Importer;
import com.day.jcr.vault.fs.io.ZipArchive;
import com.day.jcr.vault.packaging.Dependency;
import com.day.jcr.vault.packaging.ImportOptions;
import com.day.jcr.vault.packaging.InstallContext;
import com.day.jcr.vault.packaging.PackageException;
import com.day.jcr.vault.packaging.PackageId;
import com.day.jcr.vault.packaging.VaultPackage;
import com.day.jcr.vault.packaging.impl.InstallContextImpl;
import com.day.jcr.vault.packaging.impl.InstallHookProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipVaultPackage
implements VaultPackage {
    private static final Logger log = LoggerFactory.getLogger(ZipVaultPackage.class);
    public static final String UNKNOWN_PATH = "/etc/packages/unknown";
    private File file;
    private Archive archive;
    private boolean isTmpFile;
    private PackageId id;

    protected ZipVaultPackage(File file, boolean isTmpFile) throws IOException {
        this(file, isTmpFile, false);
    }

    protected ZipVaultPackage(File file, boolean isTmpFile, boolean strict) throws IOException {
        this.file = file;
        this.isTmpFile = isTmpFile;
        if (strict) {
            try {
                this.archive = new ZipArchive(file);
                this.archive.open(strict);
            }
            catch (IOException e) {
                log.error("Error while loading package {}.", (Object)file.getPath());
                throw e;
            }
        }
    }

    @Override
    public void close() {
        if (this.archive != null) {
            this.archive.close();
            this.archive = null;
        }
        if (this.file != null && this.isTmpFile) {
            FileUtils.deleteQuietly((File)this.file);
        }
        this.file = null;
    }

    @Override
    public Archive getArchive() {
        if (this.archive == null) {
            if (this.file == null) {
                log.error("Package already closed: " + this.id);
                throw new IllegalStateException("Package already closed: " + this.id);
            }
            this.archive = new ZipArchive(this.file);
            try {
                this.archive.open(false);
            }
            catch (IOException e) {
                log.error("Archive not valid.", (Throwable)e);
                throw new IllegalStateException("Archive not valid for file " + this.file, e);
            }
        }
        return this.archive;
    }

    @Override
    public PackageId getId() {
        if (this.id == null) {
            String version = this.getProperty("version");
            if (version == null) {
                log.warn("Package does not specify a version. setting to ''");
                version = "";
            }
            String group = this.getProperty("group");
            String name = this.getProperty("name");
            if (group != null && name != null) {
                this.id = new PackageId(group, name, version);
            } else {
                String path = this.getProperty("path");
                if (path == null || path.length() == 0) {
                    log.warn("Package does not specify a path. setting to 'unknown'");
                    path = UNKNOWN_PATH;
                }
                this.id = new PackageId(path, version);
            }
        }
        return this.id;
    }

    @Override
    public boolean isValid() {
        try {
            return this.getMetaInf().getFilter() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.file == null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public MetaInf getMetaInf() {
        try {
            return this.getArchive().getMetaInf();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public long getSize() {
        return this.file == null ? -1L : this.file.length();
    }

    @Override
    public Calendar getLastModified() {
        return this.getDateProperty("lastModified");
    }

    @Override
    public String getLastModifiedBy() {
        return this.getProperty("lastModifiedBy");
    }

    @Override
    public Calendar getCreated() {
        return this.getDateProperty("created");
    }

    @Override
    public String getCreatedBy() {
        return this.getProperty("createdBy");
    }

    @Override
    public Calendar getLastWrapped() {
        return this.getDateProperty("lastWrapped");
    }

    @Override
    public String getLastWrappedBy() {
        return this.getProperty("lastWrappedBy");
    }

    @Override
    public String getDescription() {
        return this.getProperty("description");
    }

    @Override
    public AccessControlHandling getACHandling() {
        String ac = this.getProperty("acHandling");
        if (ac == null) {
            return AccessControlHandling.IGNORE;
        }
        try {
            return AccessControlHandling.valueOf(ac.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.warn("invalid access control handling configured: {}", (Object)ac);
            return AccessControlHandling.IGNORE;
        }
    }

    @Override
    public boolean requiresRoot() {
        return "true".equals(this.getProperty("requiresRoot"));
    }

    @Override
    public Dependency[] getDependencies() {
        String deps = this.getProperty("dependencies");
        if (deps == null) {
            return Dependency.EMPTY;
        }
        return Dependency.parse(deps);
    }

    @Override
    public void extract(Session session, ImportOptions opts) throws RepositoryException, PackageException {
        this.extract(this.prepareExtract(session, opts), null);
    }

    protected InstallContextImpl prepareExtract(Session session, ImportOptions opts) throws RepositoryException, PackageException {
        VaultFileSystem jcrfs;
        RepositoryAddress addr;
        String userId;
        if (!this.isValid()) {
            throw new IllegalStateException("Package not valid.");
        }
        InstallHookProcessor hooks = new InstallHookProcessor();
        if (!opts.isDryRun()) {
            hooks.registerHooks(this.archive);
        }
        if ((this.requiresRoot() || hooks.hasHooks()) && (userId = session.getUserID()) != null && !"admin".equals(userId) && !"system".equals(userId)) {
            log.error("Package extraction requires admin session.");
            throw new PackageException("Package extraction requires admin session (userid " + userId + " not allowed).");
        }
        try {
            addr = new RepositoryAddress("/" + session.getWorkspace().getName() + "/");
        }
        catch (URISyntaxException e) {
            throw new PackageException("Unable to create repository address: " + e);
        }
        Importer importer = new Importer();
        if (opts.getListener() != null) {
            importer.setTracker(opts.getListener());
        }
        if (opts.getNtInstaller() != null) {
            importer.setNodeTypeInstaller(opts.getNtInstaller());
        }
        importer.setStrict(opts.isStrict());
        try {
            importer.setPatchDirectory(opts.getPatchDirectory());
        }
        catch (IOException e) {
            throw new PackageException("Invalid patch directory.", e);
        }
        importer.setPatchKeepInRepo(opts.isPatchKeepInRepo());
        importer.setPatchParentPath(opts.getPatchParentPath());
        importer.setDryRun(opts.isDryRun());
        importer.setAutoSaveThreshold(opts.getAutoSaveThreshold());
        importer.setImportMode(opts.getImportMode());
        AccessControlHandling ac = this.getACHandling();
        if (opts.getAccessControlHandling() != null && !(ac = opts.getAccessControlHandling()).equals((Object)this.getACHandling())) {
            log.info("Packages access control handling overwritten by import options: {}", (Object)ac);
        }
        importer.setAccessControlHandling(ac);
        try {
            jcrfs = Mounter.mount(null, this.getMetaInf().getFilter(), addr, null, session);
        }
        catch (IOException e) {
            throw new PackageException("Unable to mount JcrFS.", e);
        }
        return new InstallContextImpl(jcrfs, this, importer, hooks, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(InstallContextImpl ctx, List<String> subPackages) throws RepositoryException, PackageException {
        InstallHookProcessor hooks = ctx.getHooks();
        Importer importer = ctx.getImporter();
        try {
            if (!hooks.execute(ctx)) {
                throw new PackageException("Import aborted during prepare phase.");
            }
            try {
                importer.run(this.archive, ctx.getVaultFileSystem().getRoot());
            }
            catch (Exception e) {
                log.error("Error during install.", (Throwable)e);
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException(e);
            }
            ctx.setPhase(InstallContext.Phase.INSTALLED);
            hooks.execute(ctx);
            if (importer.hasErrors() && ctx.getImportOptions().isStrict()) {
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException("Errors during import.");
            }
        }
        finally {
            ctx.setPhase(InstallContext.Phase.END);
            hooks.execute(ctx);
            try {
                ctx.getVaultFileSystem().unmount();
            }
            catch (RepositoryException e) {
                log.warn("error during unmount: {}", (Object)e.toString());
            }
        }
        if (subPackages != null) {
            subPackages.addAll(importer.getSubPackages());
        }
    }

    private Calendar getDateProperty(String name) {
        try {
            String p = this.getProperty(name);
            return p == null ? null : ISO8601.parse((String)p);
        }
        catch (Exception e) {
            log.error("Error while converting date property", (Throwable)e);
            return null;
        }
    }

    private String getProperty(String name) {
        try {
            Properties props = this.getMetaInf().getProperties();
            return props == null ? null : props.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

