/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.util;

import com.day.jcr.vault.util.Text;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<E> {
    private final char seperator;
    private Node<E> root = new Node(null, "");

    public Tree() {
        this('/');
    }

    public Tree(char seperator) {
        this.seperator = seperator;
    }

    public void clear() {
        ((Node)this.root).elem = null;
        ((Node)this.root).children.clear();
    }

    public E put(String path, E elem) {
        Node<E> n = this.get(path, true);
        Object previous = ((Node)n).elem;
        ((Node)n).elem = elem;
        return (E)previous;
    }

    public E get(String path) {
        Node<E> n = this.get(path, false);
        return (E)(n == null ? null : ((Node)n).elem);
    }

    public E remove(String path) {
        Node<E> n = this.get(path, false);
        if (n == null) {
            return null;
        }
        Object previous = ((Node)n).elem;
        ((Node)n).elem = null;
        ((Node)n).prune();
        return (E)previous;
    }

    private Node<E> get(String path, boolean create) {
        String[] segs = Text.explode(path, this.seperator);
        Node n = this.root;
        for (String name : segs) {
            Node c = n.get(name, create);
            if (c == null) {
                return null;
            }
            n = c;
        }
        return n;
    }

    public void removeChildren(String path) {
        Node<E> n = this.get(path, false);
        if (n != null) {
            ((Node)n).removeChildren();
        }
    }

    public Map<String, E> map() {
        LinkedHashMap map = new LinkedHashMap();
        this.fill(map, this.root, "");
        return map;
    }

    public String getRootPath() {
        Node n = this.root;
        StringBuffer path = new StringBuffer();
        while (n.elem == null && n.children.size() == 1) {
            n = (Node)n.children.values().iterator().next();
            path.append(this.seperator).append(n.name);
        }
        if (path.length() == 0) {
            path.append(this.seperator);
        }
        return path.toString();
    }

    private void fill(Map<String, E> map, Node<E> node, String parentPath) {
        String path = parentPath.length() != 1 ? parentPath + this.seperator + ((Node)node).name : parentPath + ((Node)node).name;
        if (((Node)node).elem != null) {
            map.put(path, ((Node)node).elem);
        }
        for (Node child : ((Node)node).children.values()) {
            this.fill(map, child, path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<E> {
        private String name;
        private E elem;
        private final Node parent;
        private final Map<String, Node<E>> children = new HashMap<String, Node<E>>();

        private Node(Node parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        private Node<E> get(String name, boolean create) {
            Node<E> child = this.children.get(name);
            if (child == null) {
                child = new Node<E>(this, name);
                this.children.put(name, child);
            }
            return child;
        }

        private Node<E> remove(String name) {
            return this.children.remove(name);
        }

        private void prune() {
            if (this.children.isEmpty() && this.elem == null && this.parent != null) {
                this.parent.remove(this.name);
                this.parent.prune();
            }
        }

        private void removeChildren() {
            this.children.clear();
            this.prune();
        }
    }
}

