/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.api;

import com.day.jcr.vault.fs.api.FilterSet;
import com.day.jcr.vault.fs.api.PathFilter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFilterSet
extends FilterSet<PathFilter> {
    public static final PathFilterSet INCLUDE_ALL = (PathFilterSet)new PathFilterSet().addInclude(PathFilter.ALL).seal();
    public static final PathFilterSet EXCLUDE_ALL = (PathFilterSet)new PathFilterSet().addExclude(PathFilter.ALL).seal();
    private boolean onlyRelativePatterns;

    public PathFilterSet() {
    }

    public PathFilterSet(String root) {
        super(root);
    }

    public boolean contains(String path) {
        if (!this.covers(path)) {
            return false;
        }
        List entries = this.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        boolean result = !entries.get((int)0).include;
        for (FilterSet.Entry entry : entries) {
            if (!((PathFilter)entry.filter).matches(path)) continue;
            result = entry.include;
        }
        return result;
    }

    @Override
    public FilterSet seal() {
        if (!this.isSealed()) {
            super.seal();
            this.onlyRelativePatterns = true;
            for (FilterSet.Entry entry : this.getEntries()) {
                if (entry.include && !((PathFilter)entry.filter).isAbsolute()) continue;
                this.onlyRelativePatterns = false;
                break;
            }
        }
        return this;
    }

    public boolean hasOnlyRelativePatterns() {
        this.seal();
        return this.onlyRelativePatterns;
    }
}

