/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.config;

import com.day.jcr.vault.fs.api.VaultFsConfig;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.config.AbstractVaultFsConfig;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.DefaultWorkspaceFilter;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.config.VaultSettings;
import com.day.jcr.vault.fs.spi.CNDReader;
import com.day.jcr.vault.fs.spi.NodeTypeSet;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetaInf
implements MetaInf {
    private static Logger log = LoggerFactory.getLogger(DefaultMetaInf.class);
    private VaultSettings settings;
    private WorkspaceFilter filter;
    private VaultFsConfig config;
    private Properties properties;
    private Collection<NodeTypeSet> cnds = new LinkedList<NodeTypeSet>();
    private boolean hasDefinition;

    @Override
    public int getPackageFormatVersion() {
        String prop;
        String string = prop = this.properties == null ? null : this.properties.getProperty("packageFormatVersion");
        if (prop != null) {
            try {
                return Integer.getInteger(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 2;
    }

    public void loadFilter(InputStream in, String systemId) throws ConfigurationException, IOException {
        DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
        filter.load(in);
        this.setFilter(filter);
        log.info("Loaded filter from {}.", (Object)systemId);
    }

    public void loadConfig(InputStream in, String systemId) throws ConfigurationException, IOException {
        VaultFsConfig config = AbstractVaultFsConfig.load(in, systemId);
        this.setConfig(config);
        log.info("Loaded config from {}.", (Object)systemId);
    }

    public void loadSettings(InputStream in, String systemId) throws ConfigurationException, IOException {
        VaultSettings settings = new VaultSettings();
        settings.load(in);
        this.setSettings(settings);
        log.info("Loaded settings from {}.", (Object)systemId);
    }

    public void loadProperties(InputStream in, String systemId) throws IOException {
        Properties props = new Properties();
        props.loadFromXML(in);
        this.setProperties(props);
        log.info("Loaded properties from {}.", (Object)systemId);
    }

    public void loadCNDs(InputStream in, String systemId) throws IOException {
        Properties props = new Properties();
        props.loadFromXML(in);
        this.setProperties(props);
        log.info("Loaded properties from {}.", (Object)systemId);
    }

    public void save(File metaDir) throws IOException {
        if (!metaDir.isDirectory()) {
            throw new IOException("meta directory does not exist or is non a directory: " + metaDir.getAbsolutePath());
        }
        this.saveConfig(metaDir);
        this.saveFilter(metaDir);
        this.saveSettings(metaDir);
        this.saveProperties(metaDir);
    }

    @Override
    public VaultSettings getSettings() {
        return this.settings;
    }

    public void setSettings(VaultSettings settings) {
        this.settings = settings;
    }

    @Override
    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WorkspaceFilter filter) {
        this.filter = filter;
    }

    @Override
    public VaultFsConfig getConfig() {
        return this.config;
    }

    public void setConfig(VaultFsConfig config) {
        this.config = config;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Collection<NodeTypeSet> getNodeTypes() {
        return this.cnds;
    }

    public void setCNDs(Collection<NodeTypeSet> cnds) {
        this.cnds = cnds;
    }

    @Override
    public boolean hasDefinition() {
        return this.hasDefinition;
    }

    public void setHasDefinition(boolean hasDefinition) {
        this.hasDefinition = hasDefinition;
    }

    protected void loadSettings(File metaDir) throws ConfigurationException, IOException {
        File file = new File(metaDir, "settings.xml");
        if (file.isFile()) {
            VaultSettings settings = new VaultSettings();
            settings.load(file);
            this.settings = settings;
        } else {
            this.settings = VaultSettings.createDefault();
        }
    }

    protected void saveSettings(File metaDir) throws IOException {
        if (this.settings != null) {
            File file = new File(metaDir, "settings.xml");
            this.settings.save(file);
        }
    }

    protected void loadConfig(File metaDir) throws ConfigurationException, IOException {
        File file = new File(metaDir, "config.xml");
        if (file.isFile()) {
            this.config = AbstractVaultFsConfig.load(file);
        }
    }

    protected void saveConfig(File metaDir) throws IOException {
        if (this.config != null) {
            File file = new File(metaDir, "config.xml");
            IOUtils.copy((InputStream)this.config.getSource(), (OutputStream)FileUtils.openOutputStream((File)file));
        }
    }

    protected void loadFilter(File metaDir) throws ConfigurationException, IOException {
        File file = new File(metaDir, "filter.xml");
        if (file.isFile()) {
            DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
            filter.load(file);
            this.filter = filter;
        }
    }

    protected void saveFilter(File metaDir) throws IOException {
        if (this.filter != null) {
            File file = new File(metaDir, "filter.xml");
            IOUtils.copy((InputStream)this.filter.getSource(), (OutputStream)FileUtils.openOutputStream((File)file));
        }
    }

    protected void loadProperties(File metaDir) throws IOException {
        File file = new File(metaDir, "properties.xml");
        if (file.isFile()) {
            Properties properties = new Properties();
            properties.loadFromXML(FileUtils.openInputStream((File)file));
            this.properties = properties;
        }
    }

    protected void saveProperties(File metaDir) throws IOException {
        if (this.properties != null) {
            File file = new File(metaDir, "properties.xml");
            this.properties.storeToXML((OutputStream)FileUtils.openOutputStream((File)file), "Custom Vault Properties", "utf-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCNDs(File metaDir, boolean strict) throws IOException {
        for (File file : metaDir.listFiles()) {
            if (!file.getName().endsWith(".cnd")) continue;
            InputStreamReader r = null;
            try {
                r = new InputStreamReader((InputStream)new FileInputStream(file), "utf8");
                CNDReader reader = ServiceProviderFactory.getProvider().getCNDReader();
                reader.read(r, file.getName(), null);
                this.cnds.add(reader);
            }
            catch (IOException e) {
                block5: {
                    try {
                        log.error("Error while reading CND: {}", (Object)e.toString());
                        if (!strict) break block5;
                        throw new IOException(e.toString());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(r);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)r);
                continue;
            }
            IOUtils.closeQuietly((Reader)r);
        }
    }
}

