/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.filter;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.filter.DepthItemFilter;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class DeclaringTypeItemFilter
extends DepthItemFilter {
    private String nodeType;
    private boolean propsOnly;

    public DeclaringTypeItemFilter() {
    }

    public DeclaringTypeItemFilter(String nodeType, boolean propsOnly, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.nodeType = nodeType;
        this.propsOnly = propsOnly;
    }

    public DeclaringTypeItemFilter(String nodeType, boolean propsOnly) {
        this(nodeType, propsOnly, 0, Integer.MAX_VALUE);
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setPropsOnly(String propsOnly) {
        this.propsOnly = Boolean.valueOf(propsOnly);
    }

    public boolean matches(Item item) throws RepositoryException {
        if (item.isNode()) {
            return !this.propsOnly && ((Node)item).getDefinition().getDeclaringNodeType().getName().equals(this.nodeType);
        }
        return ((Property)item).getDefinition().getDeclaringNodeType().getName().equals(this.nodeType);
    }

    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(false, "nodeType: %s", this.nodeType);
        ctx.printf(true, "propsOnly: %b", this.propsOnly);
        ctx.outdent();
    }
}

