/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ImportMode;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.AbstractArtifactHandler;
import com.day.jcr.vault.fs.impl.io.DocViewSAXImporter;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.util.PathUtil;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericArtifactHandler
extends AbstractArtifactHandler {
    private static final Logger log = LoggerFactory.getLogger(GenericArtifactHandler.class);

    public ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact primary = artifacts.getPrimaryData();
        if (primary == null) {
            return null;
        }
        ImportInfoImpl info = null;
        VaultInputSource source = primary.getInputSource();
        if (source != null && primary.getSerializationType() == SerializationType.XML_DOCVIEW) {
            info = new ImportInfoImpl();
            String path = PathUtil.getPath(parent, name);
            if ((name.length() == 0 || parent.hasNode(name)) && wspFilter.getImportMode(path) == ImportMode.MERGE) {
                info.onNop(path);
                return info;
            }
            try {
                DocViewSAXImporter handler = new DocViewSAXImporter(parent, name, artifacts, wspFilter);
                handler.setAclHandling(this.getAcHandling());
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputSource)source, (DefaultHandler)handler);
                info.merge(handler.getInfo());
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (SAXException e) {
                info = new ImportInfoImpl();
                info.onError(path, e);
                log.error("Error while parsing {}: {}", (Object)source.getSystemId(), (Object)e);
            }
        }
        return info;
    }
}

