/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi.impl.jcr10;

import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.spi.DefaultNodeTypeSet;
import com.day.jcr.vault.fs.spi.NodeTypeInstaller;
import com.day.jcr.vault.fs.spi.NodeTypeSet;
import com.day.jcr.vault.fs.spi.ProgressTracker;
import com.day.jcr.vault.fs.spi.impl.jcr10.compact.CompactNodeTypeDefWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackrabbitCNDInstaller
implements NodeTypeInstaller {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitCNDInstaller.class);
    private final Session session;

    public JackrabbitCNDInstaller(Session session) {
        this.session = session;
    }

    @Override
    public Collection<NodeType> install(ProgressTracker tracker, NodeTypeSet types) throws IOException, RepositoryException {
        NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
        if (!(ntMgr instanceof JackrabbitNodeTypeManager)) {
            log.error("Unable to import CND. No JackrabbitNodeTypeManager (is {})", (Object)ntMgr.getClass().getName());
            return Collections.emptyList();
        }
        DefaultNodeTypeSet set = types instanceof DefaultNodeTypeSet ? (DefaultNodeTypeSet)types : new DefaultNodeTypeSet(types);
        log.debug("Removing registered nodetypes");
        SessionNamespaceResolver nsResolver = new SessionNamespaceResolver(this.session);
        DefaultNamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)nsResolver);
        NodeTypeIterator iter = ntMgr.getAllNodeTypes();
        while (iter.hasNext()) {
            NodeType nt = iter.nextNodeType();
            set.remove(npResolver.getQName(nt.getName()));
        }
        if (tracker == null) {
            tracker = new ProgressTracker();
            tracker.setEnabled(false);
        }
        ProgressTrackerListener.Mode mode = tracker.setMode(ProgressTrackerListener.Mode.TEXT);
        Map pfxToURI = set.getNamespaceMapping().getPrefixToURIMapping();
        if (!pfxToURI.isEmpty()) {
            for (Object o : pfxToURI.keySet()) {
                String prefix = (String)o;
                String uri = (String)pfxToURI.get(prefix);
                try {
                    this.session.getNamespacePrefix(uri);
                    this.track(tracker, "-", prefix + " -> " + uri);
                }
                catch (RepositoryException e) {
                    this.session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
                    this.track(tracker, "A", prefix + " -> " + uri);
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "utf8");
        CompactNodeTypeDefWriter cndWriter = new CompactNodeTypeDefWriter((Writer)w, (NamespaceResolver)nsResolver, true);
        cndWriter.write(set.getNodeTypes().values());
        cndWriter.close();
        ((Writer)w).close();
        out.close();
        ((JackrabbitNodeTypeManager)ntMgr).registerNodeTypes((InputStream)new ByteArrayInputStream(out.toByteArray()), "text/x-jcr-cnd");
        for (QNodeTypeDefinition t : set.getRemoved().values()) {
            String name = npResolver.getJCRName(t.getName());
            this.track(tracker, "-", name);
        }
        LinkedList<NodeType> nts = new LinkedList<NodeType>();
        for (QNodeTypeDefinition t : set.getNodeTypes().values()) {
            String name = npResolver.getJCRName(t.getName());
            this.track(tracker, "A", name);
            nts.add(this.session.getWorkspace().getNodeTypeManager().getNodeType(name));
        }
        tracker.setMode(mode);
        return nts;
    }

    private void track(ProgressTracker tracker, String action, String path) {
        log.info("{} {}", (Object)action, (Object)path);
        if (tracker != null) {
            tracker.track(action, path);
        }
    }
}

