/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi.impl.jcr20;

import com.day.jcr.vault.fs.spi.ACLManagement;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;

public class JcrACLManagement
implements ACLManagement {
    public boolean isACLNodeType(String name) {
        return name.equals("rep:ACL");
    }

    public boolean isAccessControllableMixin(String name) {
        return name.equals("rep:AccessControllable");
    }

    public boolean isACLNode(Node node) throws RepositoryException {
        return node.isNodeType("rep:Policy");
    }

    public boolean ensureAccessControllable(Node node) throws RepositoryException {
        if (!node.isNodeType("rep:AccessControllable")) {
            node.addMixin("rep:AccessControllable");
            return true;
        }
        return false;
    }

    public void clearACL(Node node) throws RepositoryException {
        AccessControlManager ac = node.getSession().getAccessControlManager();
        String pPath = node.getPath();
        for (AccessControlPolicy p : ac.getPolicies(pPath)) {
            ac.removePolicy(pPath, p);
        }
    }
}

