/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.util;

import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.api.RepositoryAddress;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.util.RepositoryProvider;
import com.day.jcr.vault.util.Text;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RepositoryCopier {
    private static final Logger log = LoggerFactory.getLogger(RepositoryCopier.class);
    protected ProgressTrackerListener tracker;
    private int numNodes = 0;
    private int totalNodes = 0;
    private long totalSize = 0L;
    private long currentSize = 0L;
    private int batchSize = 1024;
    private long start = 0L;
    private WorkspaceFilter srcFilter;
    private Map<String, String> prefixMapping = new HashMap<String, String>();
    private boolean onlyNewer;
    private boolean update;
    private Session srcSession;
    private Session dstSession;
    private String cqLastModified;

    public void setTracker(ProgressTrackerListener tracker) {
        this.tracker = tracker;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSourceFilter(WorkspaceFilter srcFilter) {
        this.srcFilter = srcFilter;
    }

    public void setOnlyNewer(boolean onlyNewer) {
        this.onlyNewer = onlyNewer;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(RepositoryAddress src, RepositoryAddress dst, boolean recursive) {
        this.track("", "Copy %s to %s (%srecursive)", src, dst, recursive ? "" : "non-");
        this.srcSession = null;
        this.dstSession = null;
        try {
            Node dstRoot;
            Node srcRoot;
            Repository dstRepo;
            Repository srcRepo;
            RepositoryProvider repProvider = new RepositoryProvider();
            try {
                srcRepo = repProvider.getRepository(src);
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving src repository {}: {}", (Object)src, (Object)e.toString());
                if (this.srcSession != null) {
                    this.srcSession.logout();
                    this.srcSession = null;
                }
                if (this.dstSession != null) {
                    this.dstSession.logout();
                    this.dstSession = null;
                }
                return;
            }
            try {
                dstRepo = repProvider.getRepository(dst);
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving dst repository {}: {}", (Object)dst, (Object)e.toString());
                if (this.srcSession != null) {
                    this.srcSession.logout();
                    this.srcSession = null;
                }
                if (this.dstSession != null) {
                    this.dstSession.logout();
                    this.dstSession = null;
                }
                return;
            }
            try {
                Credentials srcCreds = src.getCredentials();
                this.srcSession = srcRepo.login(srcCreds, src.getWorkspace());
            }
            catch (RepositoryException e) {
                log.error("Error while logging in src repository {}: {}", (Object)src, (Object)e.toString());
                if (this.srcSession != null) {
                    this.srcSession.logout();
                    this.srcSession = null;
                }
                if (this.dstSession != null) {
                    this.dstSession.logout();
                    this.dstSession = null;
                }
                return;
            }
            try {
                Credentials dstCreds = dst.getCredentials();
                this.dstSession = dstRepo.login(dstCreds, dst.getWorkspace());
            }
            catch (RepositoryException e) {
                log.error("Error while logging in dst repository {}: {}", (Object)dst, (Object)e.toString());
                if (this.srcSession != null) {
                    this.srcSession.logout();
                    this.srcSession = null;
                }
                if (this.dstSession != null) {
                    this.dstSession.logout();
                    this.dstSession = null;
                }
                return;
            }
            String dstParent = Text.getRelativeParent(dst.getPath(), 1);
            String dstName = this.checkNameSpace(Text.getName(dst.getPath()));
            try {
                srcRoot = (Node)this.srcSession.getItem(src.getPath());
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving src node {}: {}", (Object)src.getPath(), (Object)e.toString());
                if (this.srcSession != null) {
                    this.srcSession.logout();
                    this.srcSession = null;
                }
                if (this.dstSession != null) {
                    this.dstSession.logout();
                    this.dstSession = null;
                }
                return;
            }
            try {
                dstRoot = (Node)this.dstSession.getItem(dstParent);
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving dst parent node {}: {}", (Object)dstParent, (Object)e.toString());
                if (this.srcSession != null) {
                    this.srcSession.logout();
                    this.srcSession = null;
                }
                if (this.dstSession != null) {
                    this.dstSession.logout();
                    this.dstSession = null;
                }
                return;
            }
            try {
                this.cqLastModified = this.srcSession.getNamespacePrefix("http://www.day.com/jcr/cq/1.0") + ":lastModified";
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            try {
                this.numNodes = 0;
                this.totalNodes = 0;
                this.currentSize = 0L;
                this.totalSize = 0L;
                this.start = System.currentTimeMillis();
                this.copy(srcRoot, dstRoot, dstName, recursive);
                if (this.numNodes > 0) {
                    this.track("", "Saving %d nodes...", this.numNodes);
                    this.dstSession.save();
                    this.track("", "Done.", new Object[0]);
                }
                long end = System.currentTimeMillis();
                this.track("", "Copy completed. %d nodes in %dms. %d bytes", this.totalNodes, end - this.start, this.totalSize);
            }
            catch (RepositoryException e) {
                log.error("Error during copy: {}", (Object)e.toString());
            }
        }
        finally {
            if (this.srcSession != null) {
                this.srcSession.logout();
                this.srcSession = null;
            }
            if (this.dstSession != null) {
                this.dstSession.logout();
                this.dstSession = null;
            }
        }
    }

    private void copy(Node src, Node dstParent, String dstName, boolean recursive) throws RepositoryException {
        Node dst;
        String path = src.getPath();
        String dstPath = dstParent.getPath() + "/" + dstName;
        if (this.srcFilter != null && !this.srcFilter.contains(path)) {
            this.track(path, "------ I", new Object[0]);
            return;
        }
        boolean useSysView = src.getDefinition().isProtected();
        boolean isNew = false;
        boolean overwrite = this.update;
        if (dstParent.hasNode(dstName)) {
            dst = dstParent.getNode(dstName);
            if (overwrite) {
                if (this.onlyNewer && dstName.equals("jcr:content")) {
                    if (this.isNewer(src, dst)) {
                        this.track(dstPath, "%06d U", ++this.totalNodes);
                    } else {
                        overwrite = false;
                        recursive = false;
                        this.track(dstPath, "%06d -", ++this.totalNodes);
                    }
                } else {
                    this.track(dstPath, "%06d U", ++this.totalNodes);
                }
                if (useSysView) {
                    dst = this.sysCopy(src, dstParent, dstName);
                }
            } else {
                this.track(dstPath, "%06d -", ++this.totalNodes);
            }
        } else {
            try {
                dst = useSysView ? this.sysCopy(src, dstParent, dstName) : dstParent.addNode(dstName, src.getPrimaryNodeType().getName());
                this.track(dstPath, "%06d A", ++this.totalNodes);
                isNew = true;
            }
            catch (RepositoryException e) {
                log.warn("Error while adding node {} (ignored): {}", (Object)dstPath, (Object)e.toString());
                return;
            }
        }
        if (useSysView) {
            this.trackTree(dst, isNew);
        } else {
            HashSet<String> names = new HashSet<String>();
            if (overwrite || isNew) {
                PropertyIterator iter;
                if (!isNew) {
                    for (NodeType nt : dst.getMixinNodeTypes()) {
                        names.add(nt.getName());
                    }
                    for (NodeType nt : src.getMixinNodeTypes()) {
                        String mixName = this.checkNameSpace(nt.getName());
                        if (names.remove(mixName)) continue;
                        dst.addMixin(nt.getName());
                    }
                    for (String mix : names) {
                        dst.removeMixin(mix);
                    }
                } else {
                    for (NodeType nt : src.getMixinNodeTypes()) {
                        dst.addMixin(this.checkNameSpace(nt.getName()));
                    }
                }
                names.clear();
                if (!isNew) {
                    iter = dst.getProperties();
                    while (iter.hasNext()) {
                        names.add(this.checkNameSpace(iter.nextProperty().getName()));
                    }
                }
                iter = src.getProperties();
                while (iter.hasNext()) {
                    Property p = iter.nextProperty();
                    String pName = this.checkNameSpace(p.getName());
                    names.remove(pName);
                    if (p.getDefinition().isProtected()) continue;
                    if (p.getDefinition().isMultiple()) {
                        Value[] vs = p.getValues();
                        dst.setProperty(pName, vs);
                        for (long s : p.getLengths()) {
                            this.totalSize += s;
                            this.currentSize += s;
                        }
                        continue;
                    }
                    Value v = p.getValue();
                    dst.setProperty(pName, v);
                    long s = p.getLength();
                    this.totalSize += s;
                    this.currentSize += s;
                }
                for (String pName : names) {
                    try {
                        dst.getProperty(pName).remove();
                    }
                    catch (RepositoryException e) {}
                }
            }
            if (recursive) {
                NodeIterator niter;
                names.clear();
                if (overwrite && !isNew) {
                    niter = dst.getNodes();
                    while (niter.hasNext()) {
                        names.add(this.checkNameSpace(niter.nextNode().getName()));
                    }
                }
                niter = src.getNodes();
                while (niter.hasNext()) {
                    Node child = niter.nextNode();
                    String cName = this.checkNameSpace(child.getName());
                    names.remove(cName);
                    this.copy(child, dst, cName, true);
                }
                for (String name : names) {
                    try {
                        Node cNode = dst.getNode(name);
                        this.track(cNode.getPath(), "%06d D", ++this.totalNodes);
                        cNode.remove();
                    }
                    catch (RepositoryException e) {}
                }
            }
        }
        if (++this.numNodes >= this.batchSize) {
            try {
                this.track("", "Intermediate saving %d nodes (%d kB)...", this.numNodes, this.currentSize / 1000L);
                long now = System.currentTimeMillis();
                this.dstSession.save();
                long end = System.currentTimeMillis();
                this.track("", "Done in %d ms. Total time: %d, total nodes %d, %d kB", end - now, end - this.start, this.totalNodes, this.totalSize / 1000L);
                this.numNodes = 0;
                this.currentSize = 0L;
            }
            catch (RepositoryException e) {
                log.error("Error during intermediate save ({}); try again later: {}", (Object)this.numNodes, (Object)e.toString());
            }
        }
    }

    private Node sysCopy(Node src, Node dstParent, String dstName) throws RepositoryException {
        try {
            ContentHandler handler = dstParent.getSession().getImportContentHandler(dstParent.getPath(), 0);
            src.getSession().exportSystemView(src.getPath(), handler, true, false);
            return dstParent.getNode(dstName);
        }
        catch (SAXException e) {
            throw new RepositoryException("Unable to perform sysview copy", (Throwable)e);
        }
    }

    private void trackTree(Node node, boolean isNew) throws RepositoryException {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (isNew) {
                this.track(child.getPath(), "%06d A", ++this.totalNodes);
            } else {
                this.track(child.getPath(), "%06d U", ++this.totalNodes);
            }
            this.trackTree(child, isNew);
        }
    }

    private boolean isNewer(Node src, Node dst) {
        try {
            Calendar srcDate = null;
            Calendar dstDate = null;
            if (this.cqLastModified != null && src.hasProperty(this.cqLastModified) && dst.hasProperty(this.cqLastModified)) {
                srcDate = src.getProperty(this.cqLastModified).getDate();
                dstDate = dst.getProperty(this.cqLastModified).getDate();
            } else if (src.hasProperty("jcr:lastModified") && dst.hasProperty("jcr:lastModified")) {
                srcDate = src.getProperty("jcr:lastModified").getDate();
                dstDate = dst.getProperty("jcr:lastModified").getDate();
            }
            return srcDate == null || dstDate == null || srcDate.after(dstDate);
        }
        catch (RepositoryException e) {
            log.error("Unable to compare dates: {}", (Object)e.toString());
            return true;
        }
    }

    private String checkNameSpace(String name) {
        block9: {
            try {
                int idx = name.indexOf(58);
                if (idx <= 0) break block9;
                String prefix = name.substring(0, idx);
                String mapped = this.prefixMapping.get(prefix);
                if (mapped == null) {
                    String uri = this.srcSession.getNamespaceURI(prefix);
                    try {
                        mapped = this.dstSession.getNamespacePrefix(uri);
                    }
                    catch (NamespaceException e) {
                        mapped = prefix;
                        int i = 0;
                        while (i >= 0) {
                            try {
                                this.dstSession.getWorkspace().getNamespaceRegistry().registerNamespace(mapped, uri);
                                i = -1;
                            }
                            catch (NamespaceException e1) {
                                mapped = prefix + i++;
                            }
                        }
                    }
                    this.prefixMapping.put(prefix, mapped);
                }
                if (mapped.equals(prefix)) {
                    return name;
                }
                return mapped + prefix.substring(idx);
            }
            catch (RepositoryException e) {
                log.error("Error processing namespace for {}: {}", (Object)name, (Object)e.toString());
            }
        }
        return name;
    }

    private void track(String path, String fmt, Object ... args) {
        if (this.tracker != null) {
            this.tracker.onMessage(ProgressTrackerListener.Mode.TEXT, String.format(fmt, args), path);
        }
    }
}

