/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.util.xml.serialize;

import com.day.jcr.vault.util.xml.serialize.EncodingInfo;
import com.day.jcr.vault.util.xml.xerces.util.EncodingMap;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;

public class Encodings {
    static final int DEFAULT_LAST_PRINTABLE = 127;
    static final int LAST_PRINTABLE_UNICODE = 65535;
    static final String[] UNICODE_ENCODINGS = new String[]{"Unicode", "UnicodeBig", "UnicodeLittle", "GB2312", "UTF8"};
    static final String DEFAULT_ENCODING = "UTF8";
    static Hashtable _encodings = new Hashtable();
    static final String JIS_DANGER_CHARS = "\\~\u007f\u00a2\u00a3\u00a5\u00ac\u2014\u2015\u2016\u2026\u203e\u203e\u2225\u222f\u301c\uff3c\uff5e\uffe0\uffe1\uffe2\uffe3";

    static EncodingInfo getEncodingInfo(String encoding, boolean allowJavaNames) throws UnsupportedEncodingException {
        int i;
        EncodingInfo eInfo = null;
        if (encoding == null) {
            eInfo = (EncodingInfo)_encodings.get(DEFAULT_ENCODING);
            if (eInfo != null) {
                return eInfo;
            }
            eInfo = new EncodingInfo(EncodingMap.getJava2IANAMapping(DEFAULT_ENCODING), DEFAULT_ENCODING, 65535);
            _encodings.put(DEFAULT_ENCODING, eInfo);
            return eInfo;
        }
        String jName = EncodingMap.getIANA2JavaMapping(encoding = encoding.toUpperCase(Locale.ENGLISH));
        if (jName == null) {
            if (allowJavaNames) {
                int i2;
                EncodingInfo.testJavaEncodingName(encoding);
                eInfo = (EncodingInfo)_encodings.get(encoding);
                if (eInfo != null) {
                    return eInfo;
                }
                for (i2 = 0; i2 < UNICODE_ENCODINGS.length; ++i2) {
                    if (!UNICODE_ENCODINGS[i2].equalsIgnoreCase(encoding)) continue;
                    eInfo = new EncodingInfo(EncodingMap.getJava2IANAMapping(encoding), encoding, 65535);
                    break;
                }
                if (i2 == UNICODE_ENCODINGS.length) {
                    eInfo = new EncodingInfo(EncodingMap.getJava2IANAMapping(encoding), encoding, 127);
                }
                _encodings.put(encoding, eInfo);
                return eInfo;
            }
            throw new UnsupportedEncodingException(encoding);
        }
        eInfo = (EncodingInfo)_encodings.get(jName);
        if (eInfo != null) {
            return eInfo;
        }
        for (i = 0; i < UNICODE_ENCODINGS.length; ++i) {
            if (!UNICODE_ENCODINGS[i].equalsIgnoreCase(jName)) continue;
            eInfo = new EncodingInfo(encoding, jName, 65535);
            break;
        }
        if (i == UNICODE_ENCODINGS.length) {
            eInfo = new EncodingInfo(encoding, jName, 127);
        }
        _encodings.put(jName, eInfo);
        return eInfo;
    }
}

