/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.DirectoryArtifact;
import com.day.jcr.vault.fs.HintArtifact;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.NodeNameList;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultFile;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.DefaultWorkspaceFilter;
import com.day.jcr.vault.fs.config.VaultSettings;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.FileArtifactHandler;
import com.day.jcr.vault.fs.impl.io.FolderArtifactHandler;
import com.day.jcr.vault.fs.impl.io.GenericArtifactHandler;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.fs.impl.io.InputSourceArtifact;
import com.day.jcr.vault.fs.impl.io.XmlAnalyzer;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.fs.io.AutoSave;
import com.day.jcr.vault.fs.io.ImportOptions;
import com.day.jcr.vault.fs.spi.ACLManagement;
import com.day.jcr.vault.fs.spi.CNDReader;
import com.day.jcr.vault.fs.spi.DefaultNodeTypeSet;
import com.day.jcr.vault.fs.spi.NodeTypeInstaller;
import com.day.jcr.vault.fs.spi.NodeTypeSet;
import com.day.jcr.vault.fs.spi.PrivilegeDefinitions;
import com.day.jcr.vault.fs.spi.PrivilegeInstaller;
import com.day.jcr.vault.fs.spi.ProgressTracker;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import com.day.jcr.vault.fs.spi.UserManagement;
import com.day.jcr.vault.util.PlatformNameFormat;
import com.day.jcr.vault.util.Text;
import com.day.jcr.vault.util.Tree;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Importer {
    private static final Logger log = LoggerFactory.getLogger(Importer.class);
    private WorkspaceFilter filter;
    private final Tree<PathFilterSet> filterTree = new Tree();
    private ProgressTracker tracker;
    private final DefaultNodeTypeSet nodeTypes = new DefaultNodeTypeSet("internal");
    private AutoSave autoSave = new AutoSave();
    private final Set<String> nodesToCheckin = new HashSet<String>();
    private final Map<String, String[]> memberships = new HashMap<String, String[]>();
    private boolean hasErrors = false;
    private final FolderArtifactHandler folderHandler = new FolderArtifactHandler();
    private final GenericArtifactHandler genericHandler = new GenericArtifactHandler();
    private final FileArtifactHandler fileHandler = new FileArtifactHandler();
    private final List<Archive.Entry> patches = new LinkedList<Archive.Entry>();
    private Archive archive;
    private final List<String> subPackages = new LinkedList<String>();
    private final ACLManagement aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
    private final UserManagement userManagement = ServiceProviderFactory.getProvider().getUserManagement();
    private final ImportOptions opts;
    private AutoSave cpAutosave;
    private TxInfo cpTxInfo;
    private ImportInfoImpl cpImportInfo;
    private int recoveryRetryCounter;
    private final List<TxInfo> processedInfos = new ArrayList<TxInfo>();

    public Importer() {
        this.opts = new ImportOptions();
    }

    public Importer(ImportOptions opts) {
        this.opts = opts;
    }

    public ImportOptions getOptions() {
        return this.opts;
    }

    public List<String> getSubPackages() {
        return this.subPackages;
    }

    public void setDebugFailAfterSave(int failAfterEach) {
        this.autoSave.setDebugFailEach(failAfterEach);
    }

    protected void track(String action, String path) {
        if ("E".equals(action)) {
            log.error("{} {}", (Object)action, (Object)path);
        } else {
            log.debug("{} {}", (Object)action, (Object)path);
        }
        if (this.tracker != null) {
            this.tracker.track(action, path);
        }
    }

    protected void track(Exception e, String path) {
        log.error("E {} ({})", (Object)path, (Object)e.toString());
        if (this.tracker != null) {
            this.tracker.track(e, path);
        }
    }

    public void run(Archive archive, VaultFile vaultParent) throws IOException, RepositoryException, ConfigurationException {
        Session s = vaultParent.getFileSystem().getAggregateManager().getSession();
        Node importRoot = s.getNode(vaultParent.getPath());
        this.run(archive, importRoot);
    }

    public void run(Archive archive, Node importRoot) throws IOException, RepositoryException, ConfigurationException {
        this.archive = archive;
        if (this.opts.getListener() == null) {
            this.tracker = null;
        } else {
            if (this.tracker == null) {
                this.tracker = new ProgressTracker();
            }
            this.tracker.setListener(this.opts.getListener());
        }
        int version = archive.getMetaInf().getPackageFormatVersion();
        if (version > 2) {
            String msg = "Content format version not supported (" + version + " > " + 2 + ")";
            log.warn(msg);
            throw new IOException(msg);
        }
        if (this.opts.getAutoSaveThreshold() >= 0) {
            this.autoSave.setThreshold(this.opts.getAutoSaveThreshold());
        }
        this.autoSave.setDryRun(this.opts.isDryRun());
        this.autoSave.setTracker(this.tracker);
        if (this.opts.getAccessControlHandling() == null) {
            this.opts.setAccessControlHandling(AccessControlHandling.IGNORE);
        }
        this.fileHandler.setAcHandling(this.opts.getAccessControlHandling());
        this.genericHandler.setAcHandling(this.opts.getAccessControlHandling());
        this.folderHandler.setAcHandling(this.opts.getAccessControlHandling());
        this.filter = this.opts.getFilter();
        if (this.filter == null) {
            this.filter = archive.getMetaInf().getFilter();
        }
        if (this.filter == null) {
            throw new ConfigurationException("No workspace filter.");
        }
        if (this.opts.getImportMode() != null) {
            if (this.filter instanceof DefaultWorkspaceFilter) {
                ((DefaultWorkspaceFilter)this.filter).setImportMode(this.opts.getImportMode());
            } else {
                log.warn("Unable to override import mode, incompatible filter: {}", (Object)this.filter.getClass().getName());
            }
        }
        for (PathFilterSet set : this.filter.getFilterSets()) {
            this.filterTree.put(set.getRoot(), set);
        }
        String parentPath = importRoot.getPath();
        if (parentPath.equals("/")) {
            parentPath = "";
        }
        this.track("Collecting import information...", "");
        Session session = importRoot.getSession();
        TxInfo root = this.prepare(archive.getJcrRoot(), parentPath, (NamespaceResolver)new SessionNamespaceResolver(session));
        log.debug("Access control handling set to {}", (Object)this.opts.getAccessControlHandling());
        if (this.opts.isDryRun()) {
            this.track("Dry Run: Skipping node types installation (might lead to errors).", "");
            this.track("Simulating content import...", "");
        } else {
            this.track("Installing node types...", "");
            this.installNodeTypes(session);
            this.track("Installing privileges...", "");
            this.registerPrivileges(session);
            log.debug("Starting content import. autosave is {}", (Object)this.autoSave);
            this.track("Importing content...", "");
        }
        this.cpAutosave = this.autoSave.copy();
        LinkedList<TxInfo> skipList = new LinkedList<TxInfo>();
        while (this.recoveryRetryCounter++ < 10) {
            try {
                this.commit(session, root, skipList);
                this.autoSave.save(session);
                break;
            }
            catch (RepositoryException e) {
                if (this.recoveryRetryCounter == 10) {
                    log.error("Error while committing changes. Aborting.");
                    throw e;
                }
                log.warn("Error while committing changes. Retrying import from checkpoint at {}. Retries {}/10", (Object)(this.cpTxInfo == null ? "/" : this.cpTxInfo.path), (Object)this.recoveryRetryCounter);
                this.autoSave = this.cpAutosave.copy();
                skipList.clear();
                TxInfo info = this.cpTxInfo;
                while (info != null && info.parent != null) {
                    skipList.addFirst(info);
                    info = info.parent;
                }
                this.processedInfos.clear();
                session.refresh(false);
            }
        }
        this.checkinNodes(session);
        this.applyMemberships(session);
        this.applyPatches();
        if (this.opts.isDryRun()) {
            if (this.hasErrors) {
                this.track("Package import simulation finished. (with errors, check logs!)", "");
                log.error("There were errors during package install simulation. Please check the logs for details.");
            } else {
                this.track("Package import simulation finished.", "");
            }
        } else if (this.hasErrors) {
            this.track("Package imported (with errors, check logs!)", "");
            log.error("There were errors during package install. Please check the logs for details.");
        } else {
            this.track("Package imported.", "");
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    protected VaultSettings getSettings() {
        return this.archive.getMetaInf().getSettings();
    }

    private void installNodeTypes(Session session) throws IOException, RepositoryException {
        Collection<NodeTypeSet> metaTypes = this.archive.getMetaInf().getNodeTypes();
        if (metaTypes != null) {
            for (NodeTypeSet cnd : metaTypes) {
                this.nodeTypes.add(cnd);
            }
        }
        if (!this.nodeTypes.getNodeTypes().isEmpty()) {
            NodeTypeInstaller installer = ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(session);
            try {
                log.debug("Installing node types...");
                installer.install(this.tracker, this.nodeTypes);
            }
            catch (RepositoryException e) {
                if (this.opts.isStrict()) {
                    throw e;
                }
                this.track((Exception)((Object)e), "Packaged node types");
            }
        } else {
            log.debug("No node types provided.");
        }
    }

    private void registerPrivileges(Session session) throws IOException, RepositoryException {
        PrivilegeDefinitions privileges = this.archive.getMetaInf().getPrivileges();
        if (privileges != null && !privileges.getDefinitions().isEmpty()) {
            PrivilegeInstaller installer = ServiceProviderFactory.getProvider().getDefaultPrivilegeInstaller(session);
            try {
                log.debug("Registering privileges...");
                installer.install(this.tracker, privileges);
            }
            catch (RepositoryException e) {
                if (this.opts.isStrict()) {
                    throw e;
                }
                this.track((Exception)((Object)e), "Packaged privileges");
            }
        } else {
            log.debug("No privileges provided.");
        }
    }

    protected boolean isExcluded(String fileName) {
        return this.getSettings().getIgnoredNames().contains(fileName) || fileName.equals(".vlt") || fileName.startsWith(".vlt-");
    }

    private TxInfo prepare(Archive.Entry jcrRoot, String parentPath, NamespaceResolver resolver) throws IOException, RepositoryException {
        TxInfo root = new TxInfo(null, parentPath);
        Archive.Entry contentXml = jcrRoot.getChild(".content.xml");
        if (contentXml != null) {
            if (contentXml.isDirectory()) {
                throw new IllegalArgumentException(".content.xml is not a file");
            }
            root.artifacts.add(new InputSourceArtifact(null, "", "", ArtifactType.PRIMARY, this.archive.getInputSource(contentXml), SerializationType.XML_DOCVIEW));
        }
        root.artifacts.add(new DirectoryArtifact(Text.getName(parentPath)));
        this.prepare(jcrRoot, root, resolver);
        for (PathFilterSet sets : this.filter.getFilterSets()) {
            String rootPath = sets.getRoot();
            if (parentPath.length() > 0 && rootPath.startsWith(parentPath)) {
                rootPath = rootPath.substring(parentPath.length());
            }
            String[] segments = Text.explode(rootPath, 47);
            TxInfo current = root;
            StringBuilder path = new StringBuilder();
            for (String name : segments) {
                path.append('/').append(name);
                TxInfo child = current.children().get(name);
                if (child == null) {
                    log.debug("Creating missing intermediate directory artifact for {}", (Object)name);
                    child = current.addChild(new TxInfo(current, path.toString()));
                    child.isIntermediate = true;
                }
                current = child;
            }
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(Archive.Entry directory, TxInfo parentInfo, NamespaceResolver resolver) throws IOException, RepositoryException {
        String repoPath;
        String repoName;
        String fileName;
        Collection<? extends Archive.Entry> files = directory.getChildren();
        if (files == null) {
            return;
        }
        for (Archive.Entry entry : files) {
            if (!entry.isDirectory() || this.isExcluded(fileName = entry.getName())) continue;
            repoName = PlatformNameFormat.getRepositoryName(fileName);
            repoPath = parentInfo.path + "/" + repoName;
            if (repoName.endsWith(".dir")) {
                repoName = repoName.substring(0, repoName.length() - 4);
                repoPath = parentInfo.path + "/" + repoName;
            }
            TxInfo info = parentInfo.addChild(new TxInfo(parentInfo, repoPath));
            log.debug("Creating directory artifact for {}", (Object)repoName);
            DirectoryArtifact parent = new DirectoryArtifact(repoName);
            info.artifacts.add(parent);
            Archive.Entry contentXml = entry.getChild(".content.xml");
            if (contentXml != null) {
                if (contentXml.isDirectory()) {
                    throw new IllegalArgumentException(".content.xml is not a file");
                }
                info.artifacts.add(new InputSourceArtifact(parent, ".content.xml", "", ArtifactType.PRIMARY, this.archive.getInputSource(contentXml), SerializationType.XML_DOCVIEW));
            } else {
                log.debug("Detecting intermediate directory {}", (Object)repoName);
                info.isIntermediate = true;
            }
            this.prepare(entry, info, resolver);
        }
        for (Archive.Entry entry : files) {
            if (entry.isDirectory() || this.isExcluded(fileName = entry.getName())) continue;
            repoName = PlatformNameFormat.getRepositoryName(fileName);
            repoPath = parentInfo.path + "/" + repoName;
            if (entry.getName().equals(".content.xml")) continue;
            if (this.opts.getPatchDirectory() != null && repoPath.startsWith(this.opts.getPatchParentPath())) {
                this.patches.add(entry);
                if (!this.opts.isPatchKeepInRepo()) continue;
            }
            if (repoPath.startsWith("/etc/packages/") && (repoPath.endsWith(".jar") || repoPath.endsWith(".zip"))) {
                this.subPackages.add(repoPath);
            }
            String repoBase = repoName;
            String ext = "";
            int idx = repoName.lastIndexOf(46);
            if (idx > 0) {
                repoBase = repoName.substring(0, idx);
                ext = repoName.substring(idx);
            }
            SerializationType serType = SerializationType.GENERIC;
            ArtifactType type = ArtifactType.PRIMARY;
            VaultInputSource is = this.archive.getInputSource(entry);
            if (ext.equals(".xml")) {
                serType = XmlAnalyzer.analyze(is);
                if (serType == SerializationType.XML_DOCVIEW) {
                    repoName = repoBase;
                } else {
                    ext = "";
                    serType = SerializationType.GENERIC;
                    type = ArtifactType.FILE;
                }
            } else if (ext.equals(".cnd")) {
                if (this.opts.getCndPattern().matcher(repoPath).matches()) {
                    InputStream in = is.getByteStream();
                    try {
                        InputStreamReader r = new InputStreamReader(in, "utf8");
                        CNDReader reader = ServiceProviderFactory.getProvider().getCNDReader();
                        reader.read(r, is.getSystemId(), new NamespaceMapping(resolver));
                        this.nodeTypes.add(reader);
                        log.debug("Loaded nodetypes from {}.", (Object)repoPath);
                    }
                    catch (IOException e1) {
                        log.error("Error while reading CND.", (Throwable)e1);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                ext = "";
                type = ArtifactType.FILE;
            } else if (ext.equals(".xcnd")) {
                serType = SerializationType.CND;
                repoName = repoBase;
            } else if (ext.equals(".binary")) {
                serType = SerializationType.GENERIC;
                type = ArtifactType.BINARY;
                repoName = repoBase;
            } else {
                ext = "";
                type = ArtifactType.FILE;
            }
            if (type != ArtifactType.PRIMARY) {
                TxInfo parent = parentInfo.children().get(repoName);
                if (parent == null) {
                    if (type == ArtifactType.BINARY) {
                        parent = parentInfo;
                        while (parent != null && parent.isIntermediate) {
                            parent = parent.parent;
                        }
                        if (parent == null) {
                            log.warn("No parent info found {}. using direct.");
                            parent = parentInfo;
                        }
                    } else {
                        TxInfo tx = new TxInfo(parentInfo, parentInfo.path + "/" + repoName);
                        log.debug("Creating file artifact for {}", (Object)repoName);
                        tx.artifacts.add(new InputSourceArtifact(null, repoName, ext, type, is, serType));
                        parentInfo.addChild(tx);
                    }
                }
                if (parent != null) {
                    String path = parentInfo.path + "/" + repoName;
                    String relPath = parent.name + path.substring(parent.path.length());
                    log.debug("Attaching {} artifact {}", (Object)type, (Object)path);
                    parent.artifacts.add(new InputSourceArtifact(null, relPath, ext, type, is, serType));
                }
            }
            if (type != ArtifactType.PRIMARY) continue;
            TxInfo tx = new TxInfo(parentInfo, parentInfo.path + "/" + repoName);
            log.debug("Creating primary artifact for {}", (Object)repoName);
            tx.artifacts.add(new InputSourceArtifact(null, repoName, ext, type, is, serType));
            parentInfo.addChild(tx);
        }
        Tree.Node<PathFilterSet> filterNode = this.filterTree.getNode(parentInfo.path);
        if (filterNode != null) {
            parentInfo.sort(filterNode.getChildren().keySet());
        }
    }

    private void commit(Session session, TxInfo info, LinkedList<TxInfo> skipList) throws RepositoryException, IOException {
        try {
            ImportInfoImpl imp = null;
            if (skipList.isEmpty()) {
                if (info == this.cpTxInfo) {
                    log.debug("skipping last checkpoint info {}", (Object)info.path);
                    imp = this.cpImportInfo;
                } else {
                    imp = this.commit(session, info);
                    if (imp != null) {
                        this.nodesToCheckin.addAll(imp.getToVersion());
                        this.memberships.putAll(imp.getMemberships());
                        this.autoSave.modified(imp.numModified());
                    }
                }
            } else if (log.isDebugEnabled()) {
                StringBuilder skips = new StringBuilder();
                for (TxInfo i : skipList) {
                    skips.append(i.path).append(',');
                }
                log.debug("skip list: {}", (Object)skips);
            }
            if (this.autoSave.needsSave()) {
                this.autoSave.save(session);
                this.cpTxInfo = info;
                this.cpAutosave = this.autoSave.copy();
                this.cpImportInfo = imp;
                this.recoveryRetryCounter = 0;
                this.processedInfos.clear();
            }
            TxInfo next = skipList.isEmpty() ? null : skipList.removeFirst();
            for (TxInfo child : info.children().values()) {
                if (next == null || next == child) {
                    this.commit(session, child, skipList);
                    next = null;
                    continue;
                }
                log.debug("skipping {}", (Object)child.path);
            }
            if (info.nameList != null) {
                Node node = info.getNode(session);
                if (node == null) {
                    log.warn("Unable to restore order of {}. Node does not exist.", (Object)info.path);
                } else {
                    log.debug("Restoring order of {}.", (Object)info.path);
                    info.nameList.restoreOrder(node);
                }
            }
            this.processedInfos.add(info);
        }
        catch (RepositoryException e) {
            log.error("Error while committing {}: {}", (Object)info.path, (Object)e.toString());
            throw e;
        }
    }

    private ImportInfoImpl commit(Session session, TxInfo info) throws RepositoryException, IOException {
        String path;
        Node node;
        log.debug("committing {}", (Object)info.path);
        ImportInfoImpl imp = null;
        if (info.artifacts == null) {
            log.debug("S {}", (Object)info.path);
        } else if (info.artifacts.isEmpty()) {
            if (this.filter.contains(info.path) && session.nodeExists(info.path)) {
                node = session.getNode(info.path);
                imp = new ImportInfoImpl();
                if (this.aclManagement.isACLNode(node)) {
                    if (this.opts.getAccessControlHandling() == AccessControlHandling.OVERWRITE || this.opts.getAccessControlHandling() == AccessControlHandling.CLEAR) {
                        imp.onDeleted(info.path);
                        this.aclManagement.clearACL(node.getParent());
                    }
                } else {
                    imp.onDeleted(info.path);
                    node.remove();
                }
            }
        } else if (info.artifacts.getPrimaryData() != null && info.artifacts.size() == 1) {
            node = info.getParentNode(session);
            if (node == null) {
                imp = new ImportInfoImpl();
                imp.onError(info.path, new IllegalStateException("Parent node not found."));
            } else {
                imp = this.genericHandler.accept(this.filter, node, info.artifacts.getPrimaryData().getRelativePath(), info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("generic handler did not accept " + info.path);
                }
            }
        } else if (info.artifacts.getDirectory() != null) {
            for (TxInfo child : info.children().values()) {
                if (child.artifacts == null) {
                    path = info.name + "/" + child.name;
                    info.artifacts.add(new HintArtifact(path));
                    continue;
                }
                for (Artifact a : child.artifacts.values()) {
                    String path2 = info.name + "/" + a.getRelativePath();
                    info.artifacts.add(new HintArtifact(path2));
                }
            }
            node = info.getParentNode(session);
            if (node == null) {
                imp = new ImportInfoImpl();
                imp.onError(info.path, new IllegalStateException("Parent node not found."));
            } else if (info.isIntermediate && node.hasNode(info.name)) {
                log.debug("skipping intermediate node at {}", (Object)info.path);
            } else if (info.artifacts.getPrimaryData() == null) {
                imp = this.folderHandler.accept(this.filter, node, info.name, info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("folder handler did not accept " + info.path);
                }
            } else {
                imp = this.genericHandler.accept(this.filter, node, info.artifacts.getDirectory().getRelativePath(), info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("generic handler did not accept " + info.path);
                }
            }
        } else if (info.artifacts.size(ArtifactType.FILE) > 0) {
            node = info.getParentNode(session);
            if (node == null) {
                imp = new ImportInfoImpl();
                imp.onError(info.path, new IllegalStateException("Parent node not found."));
            } else {
                imp = this.fileHandler.accept(this.filter, node, info.name, info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("file handler did not accept " + info.path);
                }
            }
        } else {
            throw new UnsupportedOperationException("ArtifactSet not supported: " + info.artifacts);
        }
        if (imp != null) {
            for (Map.Entry<String, ImportInfo.Type> entry : imp.getModifications().entrySet()) {
                path = entry.getKey();
                ImportInfo.Type type = entry.getValue();
                switch (type) {
                    case CRE: {
                        this.track("A", path);
                        this.autoSave.markResolved(path);
                        break;
                    }
                    case DEL: {
                        this.track("D", path);
                        this.autoSave.markResolved(path);
                        break;
                    }
                    case MOD: {
                        this.track("U", path);
                        this.autoSave.markResolved(path);
                        break;
                    }
                    case NOP: {
                        this.track("-", path);
                        this.autoSave.markResolved(path);
                        break;
                    }
                    case REP: {
                        this.track("R", path);
                        this.autoSave.markResolved(path);
                        break;
                    }
                    case MIS: {
                        this.track("!", path);
                        this.autoSave.markMissing(path);
                        break;
                    }
                    case ERR: {
                        Exception error = imp.getError(path);
                        if (error == null) {
                            this.track("E", path);
                        } else {
                            this.track(error, path);
                        }
                        this.hasErrors = true;
                    }
                }
            }
            if (imp.getNameList() != null && imp.getNode() != null && imp.getNameList().needsReorder(imp.getNode()) && (this.filter.contains(info.path) || imp.getModifications().get(info.path) == ImportInfo.Type.CRE)) {
                assert (info.path.equals(imp.getNode().getPath()));
                log.debug("remember to be reordered. path={} node.path={}", (Object)info.path, (Object)imp.getNode().getPath());
                info.nameList = imp.getNameList();
            }
            if (imp.getRemapped().containsKey(info.path)) {
                info.children = null;
            }
        }
        log.debug("committed {}", (Object)info.path);
        return imp;
    }

    public void checkinNodes(Session session) {
        if (this.nodesToCheckin.isEmpty()) {
            return;
        }
        if (this.opts.isDryRun()) {
            this.track("Dry run: Would commit versions...", "");
        } else {
            this.track("Committing versions...", "");
        }
        for (String path : this.nodesToCheckin) {
            try {
                Node node = session.getNode(path);
                try {
                    if (this.opts.isDryRun()) {
                        this.track("V", String.format("%s (---)", path));
                        continue;
                    }
                    Version v = node.checkin();
                    this.track("V", String.format("%s (%s)", path, v.getName()));
                }
                catch (RepositoryException e) {
                    log.error("Error while checkin node {}: {}", (Object)path, (Object)e.toString());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving node to be versioned at {}.", (Object)path, (Object)e);
            }
        }
        this.nodesToCheckin.clear();
    }

    public void applyMemberships(Session session) {
        if (this.memberships.isEmpty()) {
            return;
        }
        if (this.opts.isDryRun()) {
            this.track("Dry run: Would apply merged group memberships...", "");
        } else {
            this.track("Applying merged group memberships...", "");
        }
        for (String id : this.memberships.keySet()) {
            String[] members = this.memberships.get(id);
            String authPath = this.userManagement.getAuthorizablePath(session, id);
            if (authPath == null) continue;
            if (!this.opts.isDryRun()) {
                this.userManagement.addMembers(session, id, members);
            }
            this.track("U", String.format("%s", authPath));
        }
        try {
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Error while updating memberships.", (Throwable)e);
            try {
                session.refresh(false);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        this.memberships.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void applyPatches() {
        for (Archive.Entry e : this.patches) {
            String name;
            block7: {
                FileOutputStream out;
                InputStream in;
                name = e.getName();
                File target = new File(this.opts.getPatchDirectory(), name);
                if (this.opts.isDryRun()) {
                    log.info("Dry run: Would copy patch {} to {}", (Object)name, (Object)target.getPath());
                } else {
                    log.info("Copying patch {} to {}", (Object)name, (Object)target.getPath());
                    in = null;
                    out = null;
                    in = this.archive.getInputSource(e).getByteStream();
                    out = FileUtils.openOutputStream((File)target);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                break block7;
                catch (IOException e1) {
                    try {
                        log.error("Error while copying patch.", (Object)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            this.track("P", name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TxInfo {
        private final TxInfo parent;
        private final String path;
        private final String name;
        private ArtifactSetImpl artifacts = new ArtifactSetImpl();
        private Map<String, TxInfo> children;
        private boolean isIntermediate;
        private NodeNameList nameList;

        public TxInfo(TxInfo parent, String path) {
            log.debug("New TxInfo {}", (Object)path);
            this.parent = parent;
            this.path = path;
            this.name = Text.getName(path);
        }

        public TxInfo addChild(TxInfo child) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, TxInfo>();
            }
            this.children.put(child.name, child);
            return child;
        }

        public Map<String, TxInfo> children() {
            if (this.children == null) {
                return Collections.emptyMap();
            }
            return this.children;
        }

        public void sort(Collection<String> names) {
            if (this.children == null || this.children.size() <= 1 || names == null || names.isEmpty()) {
                return;
            }
            LinkedHashMap<String, TxInfo> ret = new LinkedHashMap<String, TxInfo>();
            Iterator<String> iter = names.iterator();
            while (iter.hasNext() && this.children.size() > 1) {
                String name = iter.next();
                TxInfo info = this.children.remove(name);
                if (info == null) continue;
                ret.put(name, info);
            }
            ret.putAll(this.children);
            this.children = ret;
        }

        public Node getParentNode(Session s) throws RepositoryException {
            Object root = s.getRootNode();
            String parentPath = Text.getRelativeParent(this.path, 1);
            if (parentPath.length() > 0 && !parentPath.equals("/")) {
                root = root.hasNode(parentPath = parentPath.substring(1)) ? root.getNode(parentPath) : null;
            }
            return root;
        }

        public Node getNode(Session s) throws RepositoryException {
            return s.nodeExists(this.path) ? s.getNode(this.path) : null;
        }

        public void discard() {
            log.debug("discarding {}", (Object)this.path);
            this.artifacts = null;
            this.children = null;
        }
    }
}

