/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.DefaultMetaInf;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.config.VaultSettings;
import com.day.jcr.vault.fs.io.AbstractArchive;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.fs.io.ZipFileArchive;
import com.day.jcr.vault.fs.io.ZipStreamArchive;
import com.day.jcr.vault.fs.spi.CNDReader;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(ZipArchive.class);
    private DefaultMetaInf inf;
    private int numEntries;
    private Archive base;
    private final File zipFile;

    public ZipArchive(File zipFile) {
        this.zipFile = zipFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(boolean strict) throws IOException {
        if (this.inf != null) {
            throw new IllegalStateException("already open.");
        }
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.zipFile)));
        this.numEntries = 0;
        this.inf = new DefaultMetaInf();
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                ++this.numEntries;
                String name = entry.getName();
                if (!name.startsWith("META-INF/vault/")) continue;
                String path = this.zipFile.getPath() + ":" + name;
                if ((name = name.substring("META-INF/vault/".length())).equals("filter.xml")) {
                    this.inf.loadFilter((InputStream)new CloseShieldInputStream((InputStream)zin), path);
                    continue;
                }
                if (name.equals("config.xml")) {
                    this.inf.loadConfig((InputStream)new CloseShieldInputStream((InputStream)zin), path);
                    continue;
                }
                if (name.equals("settings.xml")) {
                    this.inf.loadSettings((InputStream)new CloseShieldInputStream((InputStream)zin), path);
                    continue;
                }
                if (name.equals("properties.xml")) {
                    this.inf.loadProperties((InputStream)new CloseShieldInputStream((InputStream)zin), path);
                    continue;
                }
                if (name.equals("privileges.xml")) {
                    this.inf.loadPrivileges((InputStream)new CloseShieldInputStream((InputStream)zin), path);
                    continue;
                }
                if (name.equals("definition/.content.xml")) {
                    this.inf.setHasDefinition(true);
                    log.debug("Contains package definition {}.", (Object)path);
                    continue;
                }
                if (!name.endsWith(".cnd")) continue;
                try {
                    InputStreamReader r = new InputStreamReader((InputStream)new CloseShieldInputStream((InputStream)zin), "utf8");
                    CNDReader reader = ServiceProviderFactory.getProvider().getCNDReader();
                    reader.read(r, entry.getName(), null);
                    this.inf.getNodeTypes().add(reader);
                    log.debug("Loaded nodetypes from {}.", (Object)path);
                }
                catch (IOException e1) {
                    log.error("Error while reading CND: {}", (Object)e1.toString());
                    if (!strict) continue;
                    throw e1;
                }
            }
            if (this.inf.getFilter() == null) {
                log.debug("Zip {} does not contain filter definition.", (Object)this.zipFile.getPath());
            }
            if (this.inf.getConfig() == null) {
                log.debug("Zip {} does not contain vault config.", (Object)this.zipFile.getPath());
            }
            if (this.inf.getSettings() == null) {
                log.debug("Zip {} does not contain vault settings. using default.", (Object)this.zipFile.getPath());
                VaultSettings settings = new VaultSettings();
                settings.getIgnoredNames().add(".svn");
                this.inf.setSettings(settings);
            }
            if (this.inf.getProperties() == null) {
                log.debug("Zip {} does not contain properties.", (Object)this.zipFile.getPath());
            }
            if (!this.inf.getNodeTypes().isEmpty()) return;
            log.debug("Zip {} does not contain nodetypes.", (Object)this.zipFile.getPath());
            return;
        }
        catch (IOException e) {
            log.error("Error while loading zip {}.", (Object)this.zipFile.getPath());
            throw e;
        }
        catch (ConfigurationException e) {
            log.error("Error while loading zip {}.", (Object)this.zipFile.getPath());
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
        finally {
            IOUtils.closeQuietly((InputStream)zin);
        }
    }

    private Archive getBase() throws IOException {
        if (this.inf == null) {
            throw new IOException("Archive not open.");
        }
        if (this.base == null) {
            if (this.zipFile.length() > Integer.MAX_VALUE) {
                log.warn("ZipFile is larger than 2GB. Fallback to streaming archive.");
            } else {
                ZipFile zip = new ZipFile(this.zipFile, 1);
                if (zip.size() != this.numEntries) {
                    log.warn("ZipFile reports {} entries, but stream counts {} entries. Fallback to streaming archive.", (Object)String.valueOf(zip.size()), (Object)String.valueOf(this.numEntries));
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.base = new ZipFileArchive(zip);
                }
            }
            if (this.base == null) {
                this.base = new ZipStreamArchive(this.zipFile);
            }
            this.base.open(false);
        }
        return this.base;
    }

    public MetaInf getMetaInf() {
        if (this.inf == null) {
            throw new IllegalStateException("Archive not open.");
        }
        return this.inf;
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return this.getBase().openInputStream(entry);
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return this.getBase().getInputSource(entry);
    }

    public Archive.Entry getRoot() throws IOException {
        return this.getBase().getRoot();
    }

    public void close() {
        if (this.base != null) {
            this.base.close();
            this.base = null;
        }
        this.inf = null;
    }

    public String toString() {
        return this.zipFile.getPath();
    }
}

