/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging;

import com.day.jcr.vault.packaging.Version;

public class VersionRange {
    public static final VersionRange INFINITE = new VersionRange(null, true, null, true);
    private final Version low;
    private final boolean lowIncl;
    private final Version high;
    private final boolean highIncl;
    private final String str;

    public VersionRange(Version low, boolean lowIncl, Version high, boolean highIncl) {
        if (low != null && high != null) {
            int comp = low.compareTo(high);
            if (comp > 0) {
                throw new IllegalArgumentException("lower bound must be less or equal to upper bound.");
            }
            if (!(comp != 0 || lowIncl && highIncl)) {
                throw new IllegalArgumentException("invalid empty range. upper and lower bound must be inclusive.");
            }
        }
        this.low = low;
        this.lowIncl = lowIncl;
        this.high = high;
        this.highIncl = highIncl;
        StringBuilder b = new StringBuilder();
        if (low != null || high != null) {
            if (high == null) {
                if (lowIncl) {
                    b.append(low);
                } else {
                    b.append('(');
                    b.append(low);
                    b.append(",)");
                }
            } else if (low == null) {
                b.append("[,");
                b.append(high);
                b.append(highIncl ? (char)']' : ')');
            } else {
                b.append(lowIncl ? (char)'[' : '(');
                b.append(low);
                b.append(',');
                b.append(high);
                b.append(highIncl ? (char)']' : ')');
            }
        }
        this.str = b.toString();
    }

    public VersionRange(Version v) {
        this(v, true, v, true);
    }

    public Version getLow() {
        return this.low;
    }

    public boolean isLowInclusive() {
        return this.lowIncl;
    }

    public Version getHigh() {
        return this.high;
    }

    public boolean isHighInclusive() {
        return this.highIncl;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof VersionRange && this.str.equals(obj.toString());
    }

    public String toString() {
        return this.str;
    }

    public boolean isInRange(Version v) {
        int comp;
        if (this.low != null && ((comp = v.osgiCompareTo(this.low)) < 0 || comp == 0 && !this.lowIncl)) {
            return false;
        }
        return this.high == null || (comp = v.osgiCompareTo(this.high)) <= 0 && (comp != 0 || this.highIncl);
    }

    public static VersionRange fromString(String str) {
        int idx = str.indexOf(44);
        if (idx >= 0) {
            boolean linc = false;
            int lm = str.indexOf(40);
            if (lm < 0) {
                lm = str.indexOf(91);
                if (lm < 0) {
                    throw new IllegalArgumentException("Range must start with '[' or '('");
                }
                linc = true;
            }
            boolean hinc = false;
            int hm = str.indexOf(41);
            if (hm < 0) {
                hm = str.indexOf(93);
                if (hm < 0) {
                    throw new IllegalArgumentException("Range must end with ']' or ')'");
                }
                hinc = true;
            }
            String low = str.substring(lm + 1, idx).trim();
            String high = str.substring(idx + 1, hm).trim();
            Version vLow = low.length() == 0 ? null : Version.create(low);
            Version vHigh = high.length() == 0 ? null : Version.create(high);
            return new VersionRange(vLow, linc, vHigh, hinc);
        }
        if (str.length() == 0) {
            return new VersionRange(null, false, null, false);
        }
        return new VersionRange(Version.create(str), true, null, false);
    }
}

