/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.fs.Mounter;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.api.RepositoryAddress;
import com.day.jcr.vault.fs.api.VaultFileSystem;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.config.DefaultMetaInf;
import com.day.jcr.vault.fs.config.DefaultWorkspaceFilter;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.AbstractExporter;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.fs.io.Importer;
import com.day.jcr.vault.packaging.Dependency;
import com.day.jcr.vault.packaging.ExportPostProcessor;
import com.day.jcr.vault.packaging.JcrPackageDefinition;
import com.day.jcr.vault.packaging.PackageId;
import com.day.jcr.vault.packaging.VaultPackage;
import com.day.jcr.vault.packaging.impl.JcrWorkspaceFilter;
import com.day.jcr.vault.util.Text;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageDefinitionImpl
implements JcrPackageDefinition {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageDefinitionImpl.class);
    private Node defNode;
    private String userId;

    public JcrPackageDefinitionImpl(Node definitionNode) {
        this.defNode = definitionNode;
    }

    public Node getNode() {
        return this.defNode;
    }

    public PackageId getId() {
        String group = this.get("group");
        String name = this.get("name");
        String version = this.get("version");
        if (group == null || name == null || name.length() == 0) {
            String path = this.getInstallationPath();
            if (path == null) {
                log.warn("Unable to calculate installation path. setting to 'unknown'");
                path = "unknown";
            }
            return new PackageId(path, version);
        }
        return new PackageId(group, name, version);
    }

    public void setId(PackageId id, boolean autoSave) {
        this.set("group", id.getGroup(), false);
        this.set("name", id.getName(), false);
        this.set("version", id.getVersionString(), false);
    }

    private String getInstallationPath() {
        try {
            String ext;
            int idx;
            String path = this.get("path");
            if (path == null || path.length() == 0) {
                path = this.defNode.getParent().getParent().getPath();
            }
            if ((idx = path.lastIndexOf(46)) > 0 && ((ext = path.substring(idx)).equalsIgnoreCase(".zip") || ext.equalsIgnoreCase(".jar"))) {
                path = path.substring(0, idx);
            }
            return path;
        }
        catch (RepositoryException e) {
            log.warn("Error during getInstallationPath()", (Throwable)e);
            return null;
        }
    }

    public boolean isUnwrapped() {
        try {
            return this.defNode.hasProperty("unwrapped") || this.defNode.hasProperty("lastUnwrapped");
        }
        catch (RepositoryException e) {
            log.warn("Error during isUnwrapped()", (Throwable)e);
            return false;
        }
    }

    public boolean isModified() {
        if (!this.isUnwrapped()) {
            return false;
        }
        Calendar mod = this.getLastModified();
        if (mod == null) {
            return false;
        }
        Calendar uw = this.getLastWrapped();
        if (uw == null) {
            uw = this.getLastUnwrapped();
        }
        if (uw == null) {
            try {
                if (this.defNode.hasProperty("unwrapped")) {
                    return true;
                }
            }
            catch (RepositoryException e) {
                log.warn("Error while checking unwrapped property", (Throwable)e);
            }
            return false;
        }
        return mod.after(uw);
    }

    public void unwrap(VaultPackage pack, boolean force) throws RepositoryException, IOException {
        this.unwrap(pack, force, true);
    }

    public void unwrap(VaultPackage pack, boolean force, boolean autoSave) throws RepositoryException, IOException {
        if (!force && this.isUnwrapped()) {
            return;
        }
        log.info("unwrapping package {}", pack == null ? "(unknown)" : pack.getId());
        long now = System.currentTimeMillis();
        if (pack != null && pack.getFile() != null) {
            MetaInf inf = pack.getMetaInf();
            if (inf.hasDefinition()) {
                this.extractDefinition(pack.getArchive(), false);
            }
            if (inf.getFilter() != null) {
                this.writeFilter(inf.getFilter(), false);
            }
            if (inf.getProperties() != null) {
                this.writeProperties(inf.getProperties(), false);
            }
        }
        this.defNode.setProperty("unwrapped", (Value)null);
        this.defNode.setProperty("lastUnwrapped", Calendar.getInstance());
        if (autoSave) {
            this.defNode.save();
        }
        if (log.isDebugEnabled()) {
            log.debug("unwrapping package {} completed in {}ms", (Object)this.getId(), (Object)(System.currentTimeMillis() - now));
        }
    }

    private void extractDefinition(Archive packArchive, boolean autoSave) throws RepositoryException {
        Archive archive = null;
        try {
            archive = packArchive.getSubArchive("META-INF/vault/definition", true);
        }
        catch (IOException e) {
            log.error("Error while accessing sub archive", (Throwable)e);
        }
        if (archive == null) {
            log.warn("Unable to extract definition. No such entry in archive.");
            return;
        }
        Value lastUnpacked = null;
        if (this.defNode.hasProperty("lastUnpacked")) {
            lastUnpacked = this.defNode.getProperty("lastUnpacked").getValue();
        }
        Value lastUnpackedBy = null;
        if (this.defNode.hasProperty("lastUnpackedBy")) {
            lastUnpackedBy = this.defNode.getProperty("lastUnpackedBy").getValue();
        }
        Session session = this.defNode.getSession();
        String rootPath = this.defNode.getPath();
        DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
        filter.add(new PathFilterSet(rootPath));
        try {
            Node rootNode = session.getNode(rootPath);
            String defPath = this.defNode.getPath().substring(1);
            Importer importer = new Importer();
            importer.getOptions().setAutoSaveThreshold(Integer.MAX_VALUE);
            importer.getOptions().setFilter(filter);
            importer.run(archive, rootNode);
            this.defNode = session.getRootNode().getNode(defPath);
            if (lastUnpacked != null) {
                this.defNode.setProperty("lastUnpacked", lastUnpacked);
            }
            if (lastUnpackedBy != null) {
                this.defNode.setProperty("lastUnpackedBy", lastUnpackedBy);
            }
            if (autoSave) {
                this.defNode.save();
            }
        }
        catch (Exception e) {
            log.error("Unable to extract definition: {}", (Object)e.toString());
        }
    }

    public Dependency[] getDependencies() {
        try {
            if (this.defNode.hasProperty("dependencies")) {
                Property p = this.defNode.getProperty("dependencies");
                LinkedList<Dependency> deps = new LinkedList<Dependency>();
                if (p.getDefinition().isMultiple()) {
                    for (Value v : p.getValues()) {
                        deps.add(Dependency.fromString(v.getString()));
                    }
                } else {
                    deps.add(Dependency.fromString(p.getString()));
                }
                return deps.toArray(new Dependency[deps.size()]);
            }
        }
        catch (RepositoryException e) {
            log.error("Error during getDependencies()", (Throwable)e);
        }
        return Dependency.EMPTY;
    }

    protected void loadProperties(Properties props) {
        PackageId id = this.getId();
        JcrPackageDefinitionImpl.setProperty(props, "version", id.getVersionString());
        JcrPackageDefinitionImpl.setProperty(props, "name", id.getName());
        JcrPackageDefinitionImpl.setProperty(props, "group", id.getGroup());
        JcrPackageDefinitionImpl.setProperty(props, "buildCount", this.get("buildCount"));
        JcrPackageDefinitionImpl.setProperty(props, "description", this.get("jcr:description"));
        JcrPackageDefinitionImpl.setProperty(props, "requiresRoot", this.get("requiresRoot"));
        JcrPackageDefinitionImpl.setProperty(props, "requiresRestart", this.get("requiresRestart"));
        JcrPackageDefinitionImpl.setProperty(props, "lastModified", this.getCalendar("jcr:lastModified"));
        JcrPackageDefinitionImpl.setProperty(props, "lastModifiedBy", this.get("jcr:lastModifiedBy"));
        JcrPackageDefinitionImpl.setProperty(props, "lastWrapped", this.getCalendar("lastWrapped"));
        JcrPackageDefinitionImpl.setProperty(props, "lastWrappedBy", this.get("lastWrappedBy"));
        JcrPackageDefinitionImpl.setProperty(props, "created", this.getCalendar("jcr:created"));
        JcrPackageDefinitionImpl.setProperty(props, "createdBy", this.get("jcr:createdBy"));
        JcrPackageDefinitionImpl.setProperty(props, "dependencies", Dependency.toString(this.getDependencies()));
        JcrPackageDefinitionImpl.setProperty(props, "acHandling", this.get("acHandling"));
        JcrPackageDefinitionImpl.setProperty(props, "cndPattern", this.get("cndPattern"));
    }

    private static void setProperty(Properties props, String name, String value) {
        if (value == null) {
            props.remove(name);
        } else {
            props.put(name, value);
        }
    }

    private static void setProperty(Properties props, String name, Calendar value) {
        if (value == null) {
            props.remove(name);
        } else {
            props.put(name, ISO8601.format((Calendar)value));
        }
    }

    protected void writeProperties(Properties props, boolean autoSave) {
        try {
            if (props.getProperty("lastModified") != null && props.getProperty("lastModified").equals(props.getProperty("lastModifiedBy"))) {
                props = new Properties(props);
                props.setProperty("lastModifiedBy", "unknown");
            }
            this.defNode.setProperty("version", props.getProperty("version"));
            this.defNode.setProperty("buildCount", props.getProperty("buildCount"));
            this.defNode.setProperty("name", props.getProperty("name"));
            this.defNode.setProperty("group", props.getProperty("group"));
            String deps = props.getProperty("dependencies");
            if (this.defNode.hasProperty("dependencies")) {
                this.defNode.getProperty("dependencies").remove();
            }
            if (deps != null) {
                Dependency[] d = Dependency.parse(deps);
                String[] ds = new String[d.length];
                for (int i = 0; i < ds.length; ++i) {
                    ds[i] = d[i].toString();
                }
                this.defNode.setProperty("dependencies", ds);
            }
            this.defNode.setProperty("jcr:description", props.getProperty("description"));
            this.defNode.setProperty("requiresRoot", Boolean.valueOf(props.getProperty("requiresRoot", "false")).booleanValue());
            this.defNode.setProperty("requiresRestart", Boolean.valueOf(props.getProperty("requiresRestart", "false")).booleanValue());
            this.defNode.setProperty("jcr:lastModified", JcrPackageDefinitionImpl.getDate(props.getProperty("lastModified")));
            this.defNode.setProperty("jcr:lastModifiedBy", props.getProperty("lastModifiedBy"));
            this.defNode.setProperty("jcr:created", JcrPackageDefinitionImpl.getDate(props.getProperty("created")));
            this.defNode.setProperty("jcr:createdBy", props.getProperty("createdBy"));
            this.defNode.setProperty("lastWrapped", JcrPackageDefinitionImpl.getDate(props.getProperty("lastWrapped")));
            this.defNode.setProperty("lastWrappedBy", props.getProperty("lastWrappedBy"));
            this.defNode.setProperty("acHandling", props.getProperty("acHandling"));
            this.defNode.setProperty("cndPattern", props.getProperty("cndPattern"));
            if (autoSave) {
                this.defNode.save();
            }
        }
        catch (RepositoryException e) {
            log.error("error while saving properties.", (Throwable)e);
        }
    }

    private static Calendar getDate(String iso) {
        if (iso == null) {
            return null;
        }
        String tzd = iso.substring(iso.length() - 4);
        if (tzd.indexOf(58) < 0) {
            iso = iso.substring(0, iso.length() - 4);
            iso = iso + tzd.substring(0, 2);
            iso = iso + ":";
            iso = iso + tzd.substring(2);
        }
        return ISO8601.parse((String)iso);
    }

    public void dumpCoverage(ProgressTrackerListener listener) throws RepositoryException {
        WorkspaceFilter filter = this.getMetaInf().getFilter();
        filter.dumpCoverage(this.defNode.getSession(), listener, false);
    }

    public String get(String name) {
        try {
            if (this.defNode.hasProperty(name)) {
                return this.defNode.getProperty(name).getString();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during get({})", (Object)name, (Object)e);
        }
        return null;
    }

    public boolean getBoolean(String name) {
        try {
            if (this.defNode.hasProperty(name)) {
                return this.defNode.getProperty(name).getBoolean();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during getBoolean({})", (Object)name, (Object)e);
        }
        return false;
    }

    public Calendar getCalendar(String name) {
        try {
            if (this.defNode.hasProperty(name)) {
                return this.defNode.getProperty(name).getDate();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during getCalendar({})", (Object)name, (Object)e);
        }
        return null;
    }

    public void set(String name, String value, boolean autoSave) {
        try {
            this.defNode.setProperty(name, value);
            this.touch(null, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error during set({})", (Object)name, (Object)e);
        }
    }

    public void set(String name, Calendar value, boolean autoSave) {
        try {
            this.defNode.setProperty(name, value);
            this.touch(null, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error during set({})", (Object)name, (Object)e);
        }
    }

    public void set(String name, boolean value, boolean autoSave) {
        try {
            this.defNode.setProperty(name, value);
            this.touch(null, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error during set({})", (Object)name, (Object)e);
        }
    }

    public void touch(Calendar now, boolean autoSave) {
        try {
            this.defNode.setProperty("jcr:lastModified", now == null ? Calendar.getInstance() : now);
            this.defNode.setProperty("jcr:lastModifiedBy", this.getUserId());
            if (autoSave) {
                this.defNode.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during touch()", (Throwable)e);
        }
    }

    public void setFilter(WorkspaceFilter filter, boolean autoSave) {
        try {
            JcrWorkspaceFilter.saveFilter(filter, this.defNode, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error while saving filter.", (Throwable)e);
        }
    }

    public void sealForAssembly(Calendar now, boolean autoSave) {
        try {
            if (now == null) {
                now = Calendar.getInstance();
            }
            this.set("buildCount", String.valueOf(this.getBuildCount() + 1L), autoSave);
            this.defNode.setProperty("jcr:created", now);
            this.defNode.setProperty("jcr:createdBy", this.getUserId());
            this.defNode.setProperty("lastWrapped", now);
            this.defNode.setProperty("lastWrappedBy", this.getUserId());
            this.defNode.setProperty("lastUnwrapped", now);
            this.defNode.setProperty("lastUnwrappedBy", this.getUserId());
            this.defNode.setProperty("unwrapped", (Value)null);
            this.touch(now, autoSave);
        }
        catch (RepositoryException e) {
            log.error("Error during sealForAssembly()", (Throwable)e);
        }
    }

    public void sealForRewrap(Calendar now, boolean autoSave) {
        try {
            if (now == null) {
                now = Calendar.getInstance();
            }
            this.defNode.setProperty("buildCount", String.valueOf(this.getBuildCount() + 1L));
            if (!this.defNode.hasProperty("jcr:created")) {
                this.defNode.setProperty("jcr:created", now);
                this.defNode.setProperty("jcr:createdBy", this.getUserId());
            }
            this.defNode.setProperty("lastWrapped", now);
            this.defNode.setProperty("lastWrappedBy", this.getUserId());
            this.defNode.setProperty("lastUnwrapped", now);
            this.defNode.setProperty("lastUnwrappedBy", this.getUserId());
            this.defNode.setProperty("unwrapped", (Value)null);
            this.touch(now, false);
            if (autoSave) {
                this.defNode.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during sealForRewrap()", (Throwable)e);
        }
    }

    public void touchLastUnpacked(Calendar now, boolean autoSave) {
        try {
            this.defNode.setProperty("lastUnpacked", now == null ? Calendar.getInstance() : now);
            this.defNode.setProperty("lastUnpackedBy", this.getUserId());
            if (autoSave) {
                this.defNode.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during touchLastUnpacked()", (Throwable)e);
        }
    }

    public void clearLastUnpacked(boolean autoSave) {
        try {
            if (this.defNode.hasProperty("lastUnpacked")) {
                this.defNode.getProperty("lastUnpacked").remove();
            }
            if (this.defNode.hasProperty("lastUnpackedBy")) {
                this.defNode.getProperty("lastUnpackedBy").remove();
            }
            if (autoSave) {
                this.defNode.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during clearLastUnpacked()", (Throwable)e);
        }
    }

    public Calendar getLastModified() {
        return this.getCalendar("jcr:lastModified");
    }

    public String getLastModifiedBy() {
        return this.get("jcr:lastModifiedBy");
    }

    public Calendar getCreated() {
        return this.getCalendar("jcr:created");
    }

    public String getCreatedBy() {
        return this.get("jcr:createdBy");
    }

    public Calendar getLastUnwrapped() {
        return this.getCalendar("lastUnwrapped");
    }

    public String getLastWrappedBy() {
        return this.get("lastWrappedBy");
    }

    public Calendar getLastWrapped() {
        return this.getCalendar("lastWrapped");
    }

    public String getLastUnwrappedBy() {
        return this.get("lastUnwrappedBy");
    }

    public Calendar getLastUnpacked() {
        return this.getCalendar("lastUnpacked");
    }

    public String getLastUnpackedBy() {
        return this.get("lastUnpackedBy");
    }

    public boolean requiresRoot() {
        return this.getBoolean("requiresRoot");
    }

    public boolean requiresRestart() {
        return this.getBoolean("requiresRestart");
    }

    public AccessControlHandling getAccessControlHandling() {
        String acHandling = this.get("acHandling");
        try {
            return acHandling == null ? null : AccessControlHandling.valueOf(acHandling.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.warn("invalid access control handling in definition: {} of {}", (Object)acHandling, (Object)this.getId());
            return null;
        }
    }

    public String getDescription() {
        return this.get("jcr:description");
    }

    public long getBuildCount() {
        try {
            String bc = this.get("buildCount");
            return bc == null ? 0L : Long.valueOf(bc);
        }
        catch (NumberFormatException e) {
            log.warn("Wrong build count in {}.", (Object)this.getId(), (Object)e);
            return 0L;
        }
    }

    public MetaInf getMetaInf() throws RepositoryException {
        DefaultMetaInf inf = new DefaultMetaInf();
        inf.setFilter(this.readFilter());
        Properties props = new Properties();
        this.loadProperties(props);
        inf.setProperties(props);
        return inf;
    }

    public WorkspaceFilter readFilter() throws RepositoryException {
        return JcrWorkspaceFilter.loadFilter(this.defNode);
    }

    public void writeFilter(WorkspaceFilter filter, boolean save) throws RepositoryException {
        JcrWorkspaceFilter.saveFilter(filter, this.defNode, save);
    }

    public ExportPostProcessor getInjectProcessor() {
        return new InjectProcessor(this.defNode);
    }

    private String getUserId() {
        if (this.userId == null) {
            try {
                if (this.defNode != null) {
                    this.userId = this.defNode.getSession().getUserID();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (this.userId == null) {
                this.userId = "system";
            }
        }
        return this.userId;
    }

    private static class InjectProcessor
    implements ExportPostProcessor {
        private final Node defNode;

        private InjectProcessor(Node defNode) {
            this.defNode = defNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(AbstractExporter exporter) {
            try {
                RepositoryAddress addr;
                if (this.defNode.hasProperty("lastUnpacked")) {
                    this.defNode.getProperty("lastUnpacked").remove();
                }
                if (this.defNode.hasProperty("lastUnpackedBy")) {
                    this.defNode.getProperty("lastUnpackedBy").remove();
                }
                String rootPath = this.defNode.getPath();
                DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
                filter.add(new PathFilterSet(rootPath));
                try {
                    addr = new RepositoryAddress(Text.escapePath("/" + this.defNode.getSession().getWorkspace().getName() + rootPath));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                VaultFileSystem jcrfs = Mounter.mount(null, filter, addr, "/definition", this.defNode.getSession());
                exporter.setRelativePaths(true);
                exporter.setRootPath("");
                exporter.createDirectory("META-INF/vault/definition");
                exporter.export(jcrfs.getRoot(), "META-INF/vault/definition");
                jcrfs.unmount();
            }
            catch (Exception e) {
                log.error("Error during post processing", (Throwable)e);
            }
            finally {
                try {
                    this.defNode.refresh(false);
                }
                catch (RepositoryException repositoryException) {}
            }
        }
    }
}

