/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.spi.CNDReader;
import com.day.jcr.vault.fs.spi.NodeTypeInstaller;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import com.day.jcr.vault.packaging.Dependency;
import com.day.jcr.vault.packaging.ExportOptions;
import com.day.jcr.vault.packaging.JcrPackage;
import com.day.jcr.vault.packaging.JcrPackageDefinition;
import com.day.jcr.vault.packaging.JcrPackageManager;
import com.day.jcr.vault.packaging.PackageException;
import com.day.jcr.vault.packaging.PackageId;
import com.day.jcr.vault.packaging.VaultPackage;
import com.day.jcr.vault.packaging.Version;
import com.day.jcr.vault.packaging.impl.JcrPackageDefinitionImpl;
import com.day.jcr.vault.packaging.impl.JcrPackageImpl;
import com.day.jcr.vault.packaging.impl.PackageManagerImpl;
import com.day.jcr.vault.packaging.impl.ZipVaultPackage;
import com.day.jcr.vault.util.Text;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrPackageManagerImpl
extends PackageManagerImpl
implements JcrPackageManager {
    private static final Logger log = LoggerFactory.getLogger(JcrPackageManagerImpl.class);
    private static final String DEFAULT_NODETYPES = "nodetypes.cnd";
    private static final String[] FOLDER_TYPES = new String[]{"sling:Folder", "nt:folder", "nt:unstructured", null};
    private final Session session;
    private Node packRoot;

    public JcrPackageManagerImpl(Session session) {
        this.session = session;
        this.initNodeTypes();
    }

    @Override
    public JcrPackage open(PackageId id) throws RepositoryException {
        String[] exts;
        String path = id.getInstallationPath();
        for (String ext : exts = new String[]{"", ".zip", ".jar"}) {
            if (!this.session.nodeExists(path + ext)) continue;
            return this.open(this.session.getNode(path + ext));
        }
        return null;
    }

    @Override
    public JcrPackage open(Node node) throws RepositoryException {
        return this.open(node, false);
    }

    @Override
    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageImpl pack = new JcrPackageImpl(node);
        if (pack.isValid()) {
            return pack;
        }
        if (allowInvalid && node.isNodeType("nt:hierarchyNode") && node.hasProperty("jcr:content/jcr:data")) {
            return pack;
        }
        return null;
    }

    @Override
    public PackageId resolve(Dependency dependency, boolean onlyInstalled) throws RepositoryException {
        if (!this.getPackageRoot().hasNode(dependency.getGroup())) {
            return null;
        }
        Node groupNode = this.getPackageRoot().getNode(dependency.getGroup());
        NodeIterator iter = groupNode.getNodes();
        PackageId bestId = null;
        while (iter.hasNext()) {
            PackageId id;
            JcrPackageImpl pack;
            Node child = iter.nextNode();
            if (child.getName().equals(".snapshot") || !(pack = new JcrPackageImpl(child)).isValid() || onlyInstalled && !pack.isInstalled() || !dependency.matches(id = pack.getDefinition().getId()) || bestId != null && id.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
            bestId = id;
        }
        return bestId;
    }

    @Override
    public JcrPackage upload(InputStream in, boolean replace) throws RepositoryException, IOException {
        return this.upload(in, replace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JcrPackage upload(InputStream in, boolean replace, boolean strict) throws RepositoryException, IOException {
        File file = File.createTempFile("vault", ".tmp");
        FileOutputStream out = FileUtils.openOutputStream((File)file);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        return this.upload(file, true, replace, null, strict);
    }

    @Override
    public JcrPackage upload(File file, boolean isTmpFile, boolean replace, String nameHint) throws RepositoryException, IOException {
        return this.upload(file, isTmpFile, replace, nameHint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JcrPackage upload(File file, boolean isTmpFile, boolean replace, String nameHint, boolean strict) throws RepositoryException, IOException {
        ZipVaultPackage pack = new ZipVaultPackage(file, isTmpFile, strict);
        if (pack.getArchive().getJcrRoot() == null) {
            String msg = "Zip File is not a content package. Missing 'jcr_root'.";
            log.error(msg);
            pack.close();
            throw new IOException(msg);
        }
        PackageId pid = pack.getId();
        if (pid != null && pid.getInstallationPath().equals("/etc/packages/unknown")) {
            pid = null;
        }
        if (pid == null) {
            if (nameHint == null || nameHint.length() == 0) {
                throw new IOException("Package does not contain a path specification and not name hint is given.");
            }
            pid = new PackageId(nameHint);
        }
        String path = pid.getInstallationPath() + ".zip";
        String parentPath = Text.getRelativeParent(path, 1);
        String name = Text.getName(path);
        Node parent = this.mkdir(parentPath, false);
        if (parent.hasNode(name)) {
            if (replace) {
                parent.getNode(name).remove();
            } else {
                throw new ItemExistsException("Package already exists: " + path);
            }
        }
        JcrPackage jcrPack = null;
        try {
            JcrPackage jcrPackage = jcrPack = JcrPackageImpl.createNew(parent, pid, pack, false);
            return jcrPackage;
        }
        finally {
            if (jcrPack == null) {
                this.session.refresh(false);
            } else {
                this.session.save();
            }
        }
    }

    @Override
    public JcrPackage create(Node folder, String name) throws RepositoryException, IOException {
        if (folder == null) {
            folder = this.getPackageRoot();
        }
        return JcrPackageImpl.createNew(folder, new PackageId(name), null, true);
    }

    @Override
    public JcrPackage create(String group, String name) throws RepositoryException, IOException {
        return this.create(group, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JcrPackage create(String group, String name, String version) throws RepositoryException, IOException {
        String ext = Text.getName(name, '.');
        if (ext.equals("zip") || ext.equals("jar")) {
            name = name.substring(0, name.length() - 4);
        }
        PackageId pid = new PackageId(group, name, version);
        Node folder = this.mkdir(Text.getRelativeParent(pid.getInstallationPath(), 1), false);
        try {
            JcrPackage jcrPackage = JcrPackageImpl.createNew(folder, pid, null, false);
            return jcrPackage;
        }
        finally {
            this.session.save();
        }
    }

    @Override
    public void remove(JcrPackage pack) throws RepositoryException {
        JcrPackage snap = pack.getSnapshot();
        if (snap != null) {
            snap.getNode().remove();
        }
        pack.getNode().remove();
        this.session.save();
    }

    @Override
    public JcrPackage rename(JcrPackage pack, String group, String name) throws PackageException, RepositoryException {
        return this.rename(pack, group, name, null);
    }

    @Override
    public JcrPackage rename(JcrPackage pack, String group, String name, String version) throws PackageException, RepositoryException {
        if (!pack.isValid()) {
            throw new PackageException("Package is not valid.");
        }
        if (pack.getSize() > 0L && !pack.getDefinition().isUnwrapped()) {
            throw new PackageException("Package definition not unwrapped.");
        }
        JcrPackageDefinition def = pack.getDefinition();
        PackageId id = def.getId();
        PackageId newId = new PackageId(group == null ? id.getGroup() : group, name == null ? id.getName() : name, version == null ? id.getVersion() : Version.create(version));
        String dstPath = newId.getInstallationPath() + ".zip";
        if (id.equals(newId) && pack.getNode().getPath().equals(dstPath)) {
            log.info("Package id not changed. won't rename.");
            return pack;
        }
        def.setId(newId, false);
        if (!pack.getNode().getPath().equals(dstPath)) {
            if (this.session.nodeExists(dstPath)) {
                throw new PackageException("Node at " + dstPath + " already exists.");
            }
            this.mkdir(Text.getRelativeParent(dstPath, 1), false);
            this.session.move(pack.getNode().getPath(), dstPath);
        }
        this.session.save();
        Node newNode = this.session.getRootNode().getNode(dstPath.substring(1));
        return this.open(newNode);
    }

    @Override
    public void assemble(JcrPackage pack, ProgressTrackerListener listener) throws PackageException, RepositoryException, IOException {
        pack.verifyId(true, true);
        this.assemble(pack.getNode(), pack.getDefinition(), listener);
    }

    @Override
    public void assemble(Node packNode, JcrPackageDefinition definition, ProgressTrackerListener listener) throws PackageException, RepositoryException, IOException {
        FileInputStream in;
        Calendar now = Calendar.getInstance();
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)definition;
        this.validateSubPackages(def);
        def.sealForAssembly(now, true);
        ExportOptions opts = new ExportOptions();
        opts.setMetaInf(def.getMetaInf());
        opts.setListener(listener);
        opts.setPostProcessor(def.getInjectProcessor());
        VaultPackage pack = this.assemble(packNode.getSession(), opts, (File)null);
        Node contentNode = packNode.getNode("jcr:content");
        try {
            in = FileUtils.openInputStream((File)pack.getFile());
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        contentNode.setProperty("jcr:data", (InputStream)in);
        contentNode.setProperty("jcr:lastModified", now);
        contentNode.setProperty("jcr:mimeType", "application/zip");
        packNode.save();
        pack.close();
    }

    private void validateSubPackages(JcrPackageDefinitionImpl def) throws RepositoryException, PackageException {
        List<JcrPackage> subs = this.listPackages(def.getMetaInf().getFilter());
        PackageId id = def.getId();
        for (JcrPackage p : subs) {
            if (p.getDefinition().getId().equals(id)) {
                throw new PackageException("A package cannot include itself. Check filter definition.");
            }
            if (p.isSealed()) continue;
            throw new PackageException("Only sealed (built) sub packages allowed: " + p.getDefinition().getId());
        }
    }

    @Override
    public void assemble(JcrPackageDefinition definition, ProgressTrackerListener listener, OutputStream out) throws IOException, RepositoryException, PackageException {
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)definition;
        this.validateSubPackages(def);
        Calendar now = Calendar.getInstance();
        def.sealForAssembly(now, true);
        ExportOptions opts = new ExportOptions();
        opts.setMetaInf(def.getMetaInf());
        opts.setListener(listener);
        opts.setPostProcessor(def.getInjectProcessor());
        this.assemble(def.getNode().getSession(), opts, out);
    }

    @Override
    public void rewrap(JcrPackage pack, ProgressTrackerListener listener) throws PackageException, RepositoryException, IOException {
        FileInputStream in;
        VaultPackage src = pack.getPackage();
        Calendar now = Calendar.getInstance();
        pack.verifyId(true, false);
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)pack.getDefinition();
        def.sealForRewrap(now, true);
        ExportOptions opts = new ExportOptions();
        opts.setMetaInf(def.getMetaInf());
        opts.setListener(listener);
        opts.setPostProcessor(def.getInjectProcessor());
        VaultPackage dst = this.rewrap(opts, src, (File)null);
        Node packNode = pack.getNode();
        Node contentNode = packNode.getNode("jcr:content");
        try {
            in = FileUtils.openInputStream((File)dst.getFile());
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        contentNode.setProperty("jcr:data", (InputStream)in);
        contentNode.setProperty("jcr:lastModified", now);
        contentNode.setProperty("jcr:mimeType", "application/zip");
        packNode.save();
        dst.close();
    }

    @Override
    public Node getPackageRoot() throws RepositoryException {
        return this.getPackageRoot(false);
    }

    protected Node mkdir(String path, boolean autoSave) throws RepositoryException {
        if (this.session.nodeExists(path)) {
            return this.session.getNode(path);
        }
        String parentPath = Text.getRelativeParent(path, 1);
        Node parent = this.mkdir(parentPath, autoSave);
        Node node = null;
        RepositoryException lastError = null;
        for (int i = 0; node == null && i < FOLDER_TYPES.length; ++i) {
            try {
                node = parent.addNode(Text.getName(path), FOLDER_TYPES[i]);
                continue;
            }
            catch (RepositoryException e) {
                lastError = e;
            }
        }
        if (node == null) {
            throw lastError;
        }
        if (autoSave) {
            parent.save();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNodeTypes() {
        try {
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:Package");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:HierarchyNode");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:FullCoverage");
            return;
        }
        catch (RepositoryException e) {
            InputStream in = null;
            try {
                in = this.getClass().getResourceAsStream(DEFAULT_NODETYPES);
                if (in == null) {
                    throw new InternalError("Could not load nodetypes.cnd resource.");
                }
                NodeTypeInstaller installer = ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(this.session);
                CNDReader types = ServiceProviderFactory.getProvider().getCNDReader();
                types.read(new InputStreamReader(in, "utf8"), DEFAULT_NODETYPES, null);
                installer.install(null, types);
            }
            catch (Throwable e2) {
                try {
                    log.warn("Error while registering nodetypes. Package installation might not work correctly.", e2);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
            return;
        }
    }

    @Override
    public Node getPackageRoot(boolean noCreate) throws RepositoryException {
        if (this.packRoot == null) {
            Node packRoot = this.session.getRootNode();
            if (packRoot.hasNode("etc")) {
                packRoot = packRoot.getNode("etc");
            } else {
                if (noCreate) {
                    return null;
                }
                if (packRoot.isModified()) {
                    throw new RepositoryException("Unwilling to create package root folder while session has transient changes.");
                }
                packRoot = packRoot.addNode("etc", "nt:folder");
            }
            if (packRoot.hasNode("packages")) {
                packRoot = packRoot.getNode("packages");
            } else {
                if (noCreate) {
                    return null;
                }
                packRoot = packRoot.addNode("packages", "nt:folder");
                try {
                    this.session.save();
                }
                catch (RepositoryException e) {
                    try {
                        this.session.refresh(false);
                    }
                    catch (RepositoryException e1) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            this.packRoot = packRoot;
        }
        return this.packRoot;
    }

    @Override
    public List<JcrPackage> listPackages() throws RepositoryException {
        return this.listPackages(null);
    }

    @Override
    public List<JcrPackage> listPackages(WorkspaceFilter filter) throws RepositoryException {
        Node root = this.getPackageRoot(true);
        if (root == null) {
            return Collections.emptyList();
        }
        LinkedList<JcrPackage> packages = new LinkedList<JcrPackage>();
        this.listPackages(root, packages, filter, false, false);
        Collections.sort(packages);
        return packages;
    }

    @Override
    public List<JcrPackage> listPackages(String group, boolean built) throws RepositoryException {
        Node pRoot = this.getPackageRoot(true);
        if (pRoot == null) {
            return Collections.emptyList();
        }
        LinkedList<JcrPackage> packages = new LinkedList<JcrPackage>();
        if (group == null) {
            this.listPackages(pRoot, packages, null, built, false);
        } else {
            Node root = pRoot;
            if (group.length() > 0) {
                if (group.equals(pRoot.getPath())) {
                    group = "";
                } else if (group.startsWith(pRoot.getPath() + "/")) {
                    group = group.substring(pRoot.getPath().length() + 1);
                }
                if (group.startsWith("/")) {
                    return packages;
                }
                if (group.length() > 0) {
                    if (root.hasNode(group)) {
                        root = root.getNode(group);
                    } else {
                        return packages;
                    }
                }
            }
            this.listPackages(root, packages, null, built, true);
        }
        Collections.sort(packages);
        return packages;
    }

    private void listPackages(Node root, List<JcrPackage> packages, WorkspaceFilter filter, boolean built, boolean shallow) throws RepositoryException {
        if (root != null) {
            NodeIterator iter = root.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                if (child.getName().equals(".snapshot")) continue;
                JcrPackageImpl pack = new JcrPackageImpl(child);
                if (pack.isValid()) {
                    if (filter != null && !filter.contains(child.getPath()) || built && pack.getSize() <= 0L) continue;
                    packages.add(pack);
                    continue;
                }
                if (!child.hasNodes() || shallow) continue;
                this.listPackages(child, packages, filter, built, shallow);
            }
        }
    }
}

