/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.fs.io.Importer;
import com.day.jcr.vault.fs.io.ZipArchive;
import com.day.jcr.vault.packaging.Dependency;
import com.day.jcr.vault.packaging.ImportOptions;
import com.day.jcr.vault.packaging.InstallContext;
import com.day.jcr.vault.packaging.PackageException;
import com.day.jcr.vault.packaging.PackageId;
import com.day.jcr.vault.packaging.VaultPackage;
import com.day.jcr.vault.packaging.impl.InstallContextImpl;
import com.day.jcr.vault.packaging.impl.InstallHookProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipVaultPackage
implements VaultPackage {
    private static final Logger log = LoggerFactory.getLogger(ZipVaultPackage.class);
    public static final String UNKNOWN_PATH = "/etc/packages/unknown";
    private File file;
    private Archive archive;
    private boolean isTmpFile;
    private PackageId id;

    protected ZipVaultPackage(File file, boolean isTmpFile) throws IOException {
        this(file, isTmpFile, false);
    }

    protected ZipVaultPackage(File file, boolean isTmpFile, boolean strict) throws IOException {
        this.file = file;
        this.isTmpFile = isTmpFile;
        if (strict) {
            try {
                this.archive = new ZipArchive(file);
                this.archive.open(strict);
            }
            catch (IOException e) {
                log.error("Error while loading package {}.", (Object)file.getPath());
                throw e;
            }
        }
    }

    @Override
    public void close() {
        if (this.archive != null) {
            this.archive.close();
            this.archive = null;
        }
        if (this.file != null && this.isTmpFile) {
            FileUtils.deleteQuietly((File)this.file);
        }
        this.file = null;
    }

    @Override
    public Archive getArchive() {
        if (this.archive == null) {
            if (this.file == null) {
                log.error("Package already closed: " + this.id);
                throw new IllegalStateException("Package already closed: " + this.id);
            }
            this.archive = new ZipArchive(this.file);
            try {
                this.archive.open(false);
            }
            catch (IOException e) {
                log.error("Archive not valid.", (Throwable)e);
                throw new IllegalStateException("Archive not valid for file " + this.file, e);
            }
        }
        return this.archive;
    }

    @Override
    public PackageId getId() {
        if (this.id == null) {
            String version = this.getProperty("version");
            if (version == null) {
                log.warn("Package does not specify a version. setting to ''");
                version = "";
            }
            String group = this.getProperty("group");
            String name = this.getProperty("name");
            if (group != null && name != null) {
                this.id = new PackageId(group, name, version);
            } else {
                String path = this.getProperty("path");
                if (path == null || path.length() == 0) {
                    log.warn("Package does not specify a path. setting to 'unknown'");
                    path = UNKNOWN_PATH;
                }
                this.id = new PackageId(path, version);
            }
        }
        return this.id;
    }

    @Override
    public boolean isValid() {
        try {
            return this.getMetaInf().getFilter() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.file == null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public MetaInf getMetaInf() {
        try {
            return this.getArchive().getMetaInf();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public long getSize() {
        return this.file == null ? -1L : this.file.length();
    }

    @Override
    public Calendar getLastModified() {
        return this.getDateProperty("lastModified");
    }

    @Override
    public String getLastModifiedBy() {
        return this.getProperty("lastModifiedBy");
    }

    @Override
    public Calendar getCreated() {
        return this.getDateProperty("created");
    }

    @Override
    public String getCreatedBy() {
        return this.getProperty("createdBy");
    }

    @Override
    public Calendar getLastWrapped() {
        return this.getDateProperty("lastWrapped");
    }

    @Override
    public String getLastWrappedBy() {
        return this.getProperty("lastWrappedBy");
    }

    @Override
    public String getDescription() {
        return this.getProperty("description");
    }

    @Override
    public AccessControlHandling getACHandling() {
        String ac = this.getProperty("acHandling");
        if (ac == null) {
            return AccessControlHandling.IGNORE;
        }
        try {
            return AccessControlHandling.valueOf(ac.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.warn("invalid access control handling configured: {}", (Object)ac);
            return AccessControlHandling.IGNORE;
        }
    }

    @Override
    public boolean requiresRoot() {
        return "true".equals(this.getProperty("requiresRoot"));
    }

    @Override
    public Dependency[] getDependencies() {
        String deps = this.getProperty("dependencies");
        if (deps == null) {
            return Dependency.EMPTY;
        }
        return Dependency.parse(deps);
    }

    @Override
    public void extract(Session session, ImportOptions opts) throws RepositoryException, PackageException {
        this.extract(this.prepareExtract(session, opts), null);
    }

    @Override
    public void extract(Session session, com.day.jcr.vault.fs.io.ImportOptions opts) throws RepositoryException, PackageException {
        this.extract(this.prepareExtract(session, opts), null);
    }

    protected InstallContextImpl prepareExtract(Session session, com.day.jcr.vault.fs.io.ImportOptions opts) throws RepositoryException, PackageException {
        String cndPattern;
        String userId;
        if (!this.isValid()) {
            throw new IllegalStateException("Package not valid.");
        }
        InstallHookProcessor hooks = new InstallHookProcessor();
        if (!opts.isDryRun()) {
            hooks.registerHooks(this.archive, opts.getHookClassLoader());
        }
        if ((this.requiresRoot() || hooks.hasHooks()) && (userId = session.getUserID()) != null && !"admin".equals(userId) && !"system".equals(userId)) {
            log.error("Package extraction requires admin session.");
            throw new PackageException("Package extraction requires admin session (userid " + userId + " not allowed).");
        }
        Importer importer = new Importer(opts);
        AccessControlHandling ac = this.getACHandling();
        if (opts.getAccessControlHandling() == null) {
            opts.setAccessControlHandling(ac);
        }
        if ((cndPattern = this.getProperty("cndPattern")) != null) {
            try {
                opts.setCndPattern(cndPattern);
            }
            catch (PatternSyntaxException e) {
                throw new PackageException("Specified CND pattern not valid.", e);
            }
        }
        return new InstallContextImpl(session.getRootNode(), this, importer, hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(InstallContextImpl ctx, List<String> subPackages) throws RepositoryException, PackageException {
        log.info("Extracting {}", (Object)this.getId());
        InstallHookProcessor hooks = ctx.getHooks();
        Importer importer = ctx.getImporter();
        try {
            if (!hooks.execute(ctx)) {
                throw new PackageException("Import aborted during prepare phase.");
            }
            try {
                importer.run(this.archive, ctx.getImportRoot());
            }
            catch (Exception e) {
                log.error("Error during install.", (Throwable)e);
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException(e);
            }
            ctx.setPhase(InstallContext.Phase.INSTALLED);
            hooks.execute(ctx);
            if (importer.hasErrors() && ctx.getImportOptions().isStrict()) {
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException("Errors during import.");
            }
        }
        finally {
            ctx.setPhase(InstallContext.Phase.END);
            hooks.execute(ctx);
        }
        if (subPackages != null) {
            subPackages.addAll(importer.getSubPackages());
        }
        log.info("Extracting {} completed.", (Object)this.getId());
    }

    private Calendar getDateProperty(String name) {
        try {
            String p = this.getProperty(name);
            return p == null ? null : ISO8601.parse((String)p);
        }
        catch (Exception e) {
            log.error("Error while converting date property", (Throwable)e);
            return null;
        }
    }

    private String getProperty(String name) {
        try {
            Properties props = this.getMetaInf().getProperties();
            return props == null ? null : props.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

