/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.ImportMode;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.AbstractArtifactHandler;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import java.io.IOException;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

public class FolderArtifactHandler
extends AbstractArtifactHandler {
    private String nodeType = "nt:folder";

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact dir = artifacts.getDirectory();
        if (dir == null || artifacts.size() != 1) {
            return null;
        }
        ImportInfoImpl info = new ImportInfoImpl();
        if (dir.getRelativePath().length() == 0) {
            return info;
        }
        if (!parent.hasNode(dir.getRelativePath())) {
            Node node = parent.addNode(dir.getRelativePath(), this.nodeType);
            info.onCreated(node.getPath());
        } else {
            HashSet<String> hints = new HashSet<String>();
            String rootPath = parent.getPath();
            if (!rootPath.equals("/")) {
                rootPath = rootPath + "/";
            }
            for (Artifact a : artifacts.values(ArtifactType.HINT)) {
                hints.add(rootPath + a.getRelativePath());
            }
            Node node = parent.getNode(dir.getRelativePath());
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                String path = child.getPath();
                if (!wspFilter.contains(path) || wspFilter.getImportMode(path) != ImportMode.REPLACE) continue;
                if (!hints.contains(path)) {
                    if (this.getAclManagement().isACLNode(child)) {
                        if (this.acHandling != AccessControlHandling.OVERWRITE && this.acHandling != AccessControlHandling.CLEAR) continue;
                        info.onDeleted(path);
                        this.getAclManagement().clearACL(node);
                        continue;
                    }
                    info.onDeleted(path);
                    child.remove();
                    continue;
                }
                if (this.acHandling != AccessControlHandling.CLEAR || !this.getAclManagement().isACLNode(child)) continue;
                info.onDeleted(path);
                this.getAclManagement().clearACL(node);
            }
        }
        return info;
    }
}

