/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.NodeNameList;
import com.day.jcr.vault.util.PathComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInfoImpl
implements ImportInfo {
    static final Logger log = LoggerFactory.getLogger(ImportInfoImpl.class);
    private final TreeMap<String, ImportInfo.Type> mods = new TreeMap(new PathComparator());
    private final Map<String, Exception> errorMap = new HashMap<String, Exception>();
    private Map<String, String> remapped;
    private final Set<String> toVersion = new LinkedHashSet<String>();
    private NodeNameList nameList;
    private Node node;
    private int numModified;
    private Map<String, String[]> memberships;

    public static ImportInfo create(ImportInfo base) {
        if (base == null) {
            return new ImportInfoImpl();
        }
        return base;
    }

    @Override
    public ImportInfoImpl merge(ImportInfo base) {
        if (base instanceof ImportInfoImpl) {
            ImportInfoImpl baseImpl = (ImportInfoImpl)base;
            this.mods.putAll(baseImpl.mods);
            this.errorMap.putAll(baseImpl.errorMap);
            this.numModified += baseImpl.numModified;
            this.toVersion.addAll(baseImpl.toVersion);
            if (this.node == null) {
                this.node = baseImpl.node;
                this.nameList = baseImpl.nameList;
            }
            if (this.remapped == null) {
                this.remapped = baseImpl.remapped;
            } else {
                this.remapped.putAll(baseImpl.getRemapped());
            }
            if (this.memberships == null) {
                this.memberships = baseImpl.memberships;
            } else {
                this.memberships.putAll(baseImpl.getMemberships());
            }
        }
        return this;
    }

    @Override
    public NodeNameList getNameList() {
        return this.nameList;
    }

    public void setNameList(NodeNameList nameList) {
        this.nameList = nameList;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    @Override
    public void onModified(String path) {
        ImportInfo.Type prev = this.mods.get(path);
        if (prev == null || prev != ImportInfo.Type.CRE) {
            this.addMod(path, ImportInfo.Type.MOD);
        }
    }

    @Override
    public void onNop(String path) {
        if (!this.mods.containsKey(path)) {
            this.addMod(path, ImportInfo.Type.NOP);
        }
    }

    @Override
    public void onCreated(String path) {
        this.addMod(path, ImportInfo.Type.CRE);
    }

    @Override
    public void onDeleted(String path) {
        this.addMod(path, ImportInfo.Type.DEL);
    }

    @Override
    public void onReplaced(String path) {
        this.addMod(path, ImportInfo.Type.REP);
    }

    @Override
    public void onMissing(String path) {
        this.addMod(path, ImportInfo.Type.MIS);
    }

    @Override
    public void onError(String path, Exception e) {
        this.addMod(path, ImportInfo.Type.ERR);
        this.errorMap.put(path, e);
    }

    public void onRemapped(String oldPath, String newPath) {
        if (this.remapped == null) {
            this.remapped = new HashMap<String, String>();
        }
        this.remapped.put(oldPath, newPath);
    }

    public Map<String, String> getRemapped() {
        return this.remapped == null ? Collections.emptyMap() : this.remapped;
    }

    private void addMod(String path, ImportInfo.Type mod) {
        if (this.mods.get(path) != ImportInfo.Type.ERR) {
            this.mods.put(path, mod);
            if (mod != ImportInfo.Type.NOP) {
                ++this.numModified;
            }
        }
        log.debug("{} {}", (Object)mod, (Object)path);
    }

    @Override
    public TreeMap<String, ImportInfo.Type> getModifications() {
        return this.mods;
    }

    @Override
    public Exception getError(String path) {
        return this.errorMap.get(path);
    }

    @Override
    public Collection<String> getToVersion() {
        return this.toVersion;
    }

    public void registerToVersion(String path) {
        this.toVersion.add(path);
    }

    public void checkinNodes(Session session) {
        Iterator<String> iter = this.toVersion.iterator();
        while (iter.hasNext()) {
            String path = iter.next();
            iter.remove();
            try {
                Node node = session.getNode(path);
                if (!node.isNodeType("mix:versionable")) continue;
                try {
                    Version v = node.checkin();
                    log.info("Checked in versionable node {} (v={})", (Object)path, (Object)v.getName());
                }
                catch (RepositoryException e) {
                    log.error("Error while checkin node {}: {}", (Object)path, (Object)e.toString());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving node to be versioned at {}.", (Object)path, (Object)e);
            }
        }
    }

    @Override
    public int numModified() {
        return this.numModified;
    }

    @Override
    public int numErrors() {
        return this.errorMap.size();
    }

    public void registerMemberships(String id, String[] members) {
        if (this.memberships == null) {
            this.memberships = new HashMap<String, String[]>();
        }
        this.memberships.put(id, members);
    }

    public Map<String, String[]> getMemberships() {
        return this.memberships == null ? Collections.emptyMap() : this.memberships;
    }
}

