/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.config.DefaultMetaInf;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.AbstractArchive;
import com.day.jcr.vault.fs.io.Archive;
import java.io.IOException;
import java.io.InputStream;

public class SubArchive
extends AbstractArchive {
    private Archive base;
    private Archive.Entry root;
    private final boolean isJcrRoot;
    private DefaultMetaInf inf = new DefaultMetaInf();

    public SubArchive(Archive base, Archive.Entry root, boolean isJcrRoot) {
        this.base = base;
        this.root = root;
        this.isJcrRoot = isJcrRoot;
        this.inf.setSettings(base.getMetaInf().getSettings());
        this.inf.setConfig(base.getMetaInf().getConfig());
    }

    public Archive.Entry getRoot() throws IOException {
        return this.root;
    }

    public Archive.Entry getJcrRoot() throws IOException {
        if (this.isJcrRoot) {
            return this.root;
        }
        return super.getJcrRoot();
    }

    public void open(boolean strict) throws IOException {
    }

    public MetaInf getMetaInf() {
        return this.inf;
    }

    public void close() {
        this.base = null;
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return this.base.openInputStream(entry);
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return this.base.getInputSource(entry);
    }
}

