/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi.impl.jcr20;

import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.spi.PrivilegeDefinitions;
import com.day.jcr.vault.fs.spi.PrivilegeInstaller;
import com.day.jcr.vault.fs.spi.ProgressTracker;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackrabbitPrivilegeInstaller
implements PrivilegeInstaller {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitPrivilegeInstaller.class);
    private final Session session;

    public JackrabbitPrivilegeInstaller(Session session) {
        this.session = session;
    }

    @Override
    public Collection<Privilege> install(ProgressTracker tracker, PrivilegeDefinitions defs) throws IOException, RepositoryException {
        Map pfxToURI;
        Workspace wsp = this.session.getWorkspace();
        if (!(wsp instanceof JackrabbitWorkspace)) {
            throw new RepositoryException("Unable to register privileges. No JackrabbitWorkspace.");
        }
        PrivilegeManager mgr = ((JackrabbitWorkspace)wsp).getPrivilegeManager();
        ProgressTrackerListener.Mode mode = null;
        if (tracker != null) {
            mode = tracker.setMode(ProgressTrackerListener.Mode.TEXT);
        }
        if (!(pfxToURI = defs.getNamespaceMapping().getPrefixToURIMapping()).isEmpty()) {
            Iterator i$ = pfxToURI.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String prefix = o = (String)i$.next();
                String uri = (String)pfxToURI.get(prefix);
                try {
                    this.session.getNamespacePrefix(uri);
                    this.track(tracker, "-", prefix + " -> " + uri);
                }
                catch (RepositoryException e) {
                    this.session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
                    this.track(tracker, "A", prefix + " -> " + uri);
                }
            }
        }
        LinkedList<Privilege> registeredPrivs = new LinkedList<Privilege>();
        for (PrivilegeDefinition def : defs.getDefinitions()) {
            String name = this.getJCRName(def.getName());
            Privilege priv = null;
            try {
                priv = mgr.getPrivilege(name);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            if (priv == null) {
                String[] aggregateNames = new String[def.getDeclaredAggregateNames().size()];
                int i = 0;
                for (Name n : def.getDeclaredAggregateNames()) {
                    aggregateNames[i++] = this.getJCRName(n);
                }
                registeredPrivs.add(mgr.registerPrivilege(name, def.isAbstract(), aggregateNames));
                this.track(tracker, "A", name);
                continue;
            }
            this.track(tracker, "-", name);
        }
        if (tracker != null) {
            tracker.setMode(mode);
        }
        return registeredPrivs;
    }

    private void track(ProgressTracker tracker, String action, String path) {
        log.debug("{} {}", (Object)action, (Object)path);
        if (tracker != null) {
            tracker.track(action, path);
        }
    }

    private String getJCRName(Name name) {
        StringBuilder str = new StringBuilder("{");
        str.append(name.getNamespaceURI());
        str.append("}");
        str.append(name.getLocalName());
        return str.toString();
    }
}

