/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi.impl.jcr20;

import com.day.jcr.vault.fs.spi.UserManagement;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitUserManagement
implements UserManagement {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitUserManagement.class);

    public boolean isAuthorizableNodeType(String ntName) {
        return ntName.equals("rep:Group") || ntName.equals("rep:User");
    }

    public String getAuthorizablePath(Session session, String name) {
        try {
            UUID uuid = UUID.nameUUIDFromBytes(name.toLowerCase().getBytes("UTF-8"));
            return session.getNodeByIdentifier(uuid.toString()).getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addMembers(Session session, String id, String[] membersUUID) {
        if (!(session instanceof JackrabbitSession)) {
            log.warn("Unable to update membership. no jackrabbit session.");
            return;
        }
        UserManager uMgr = null;
        try {
            uMgr = ((JackrabbitSession)session).getUserManager();
        }
        catch (RepositoryException e) {
            log.warn("Unable to update membership of {}. Error while retrieving user manager.", (Object)id, (Object)e);
            return;
        }
        Authorizable auth = null;
        try {
            auth = uMgr.getAuthorizable(id);
        }
        catch (RepositoryException e) {
            log.warn("Unable to update membership of {}. Error while retrieving authorizable.", (Object)id, (Object)e);
            return;
        }
        if (auth == null) {
            log.warn("Unable to update membership of {}. No such authorizable.", (Object)id);
            return;
        }
        if (!(auth instanceof Group)) {
            log.warn("Unable to update membership of {}. No a group.", (Object)id);
            return;
        }
        Group grp = (Group)auth;
        for (String uuid : membersUUID) {
            String authId = null;
            try {
                Node authNode = session.getNodeByIdentifier(uuid);
                authId = Text.unescapeIllegalJcrChars((String)authNode.getName());
                auth = uMgr.getAuthorizable(authId);
            }
            catch (RepositoryException e) {
                log.warn("unable to add authorizable '{}' to group '{}'. No such node.", (Object)uuid, (Object)id);
            }
            try {
                if (auth == null) {
                    log.warn("unable to add authorizable '{}' to group '{}'. No such authorizable.", (Object)authId, (Object)id);
                    continue;
                }
                if (grp.isDeclaredMember(auth)) {
                    log.info("ignoring to add authorizable '{}' to group '{}'. Already member.", (Object)authId, (Object)id);
                    continue;
                }
                grp.addMember(auth);
                log.info("added authorizable '{}' to group '{}'.", (Object)authId, (Object)id);
            }
            catch (RepositoryException e) {
                log.error("Error while adding authorizable '{}' to group '{}': {}", new Object[]{authId, id, e});
            }
        }
    }
}

