/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.hotfix;

import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.packaging.Version;
import com.day.jcr.vault.packaging.hotfix.Entry;
import com.day.jcr.vault.packaging.hotfix.Hotfix;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.TreeMap;

public class Analyzer {
    private static final SimpleDateFormat dateFmt = new SimpleDateFormat("dd-MMM-yyyy");
    private String linkHotfixFormat = "[CQ530_HF_%s|%s] ";
    private String linkFeaturepackFormat = "[CQ530_FP_%s|%s] ";

    public String getLinkHotfixFormat() {
        return this.linkHotfixFormat;
    }

    public void setLinkHotfixFormat(String linkHotfixFormat) {
        this.linkHotfixFormat = linkHotfixFormat;
    }

    public String getLinkFeaturepackFormat() {
        return this.linkFeaturepackFormat;
    }

    public void setLinkFeaturepackFormat(String linkFeaturepackFormat) {
        this.linkFeaturepackFormat = linkFeaturepackFormat;
    }

    public void analyze(String[] args) throws IOException, ConfigurationException {
        System.out.println("Hotfix analyzer");
        LinkedList<File> files = new LinkedList<File>();
        for (String name : args) {
            File file = new File(name);
            if (!file.canRead()) {
                System.out.printf("Error: can't read file %s%n", name);
                continue;
            }
            files.add(file);
        }
        if (files.isEmpty()) {
            System.out.println("Error: specify at least 1 hotfix.");
            System.exit(1);
        }
        ArrayList<Hotfix> hotfixes = new ArrayList<Hotfix>(files.size());
        TreeMap<String, Entry> entries = new TreeMap<String, Entry>();
        for (File file : files) {
            Hotfix h = new Hotfix(file.getName());
            h.scan(file);
            hotfixes.add(h);
            entries.putAll(h.getEntries());
        }
        System.out.println("generating 'matrix.txt' ...");
        PrintWriter out = new PrintWriter(new File("matrix.txt"));
        out.printf("|= File/Hotfix ", new Object[0]);
        for (Hotfix h : hotfixes) {
            out.printf("|= %s ", this.getHotfixLink(h));
        }
        out.println("|");
        Version[][] matrix = new Version[entries.size()][hotfixes.size()];
        int e = 0;
        for (Entry entry : entries.values()) {
            int i = 0;
            out.printf("| %s ", entry.getId());
            for (Hotfix h : hotfixes) {
                Entry he = h.getEntries().get(entry.getId());
                if (he != null) {
                    out.printf("| %s ", he.getVersion());
                    matrix[e][i] = he.getVersion();
                } else {
                    out.printf("|  ", new Object[0]);
                }
                ++i;
            }
            out.println("|");
            ++e;
        }
        out.close();
        System.out.println("generating 'dependencies.txt' ...");
        out = new PrintWriter(new File("dependencies.txt"));
        for (Hotfix h1 : hotfixes) {
            for (Hotfix h2 : hotfixes) {
                h1.resolveDependencies(h2);
            }
        }
        for (Hotfix h1 : hotfixes) {
            String date = "";
            Calendar created = h1.getCreated();
            if (created != null) {
                date = "(" + dateFmt.format(created.getTime()) + ")";
            }
            out.printf("== Dependencies of %s %s==%n", this.getHotfixLink(h1), date);
            out.printf("| Dependencies |", new Object[0]);
            boolean hasDeps = false;
            for (Hotfix.Dependency d : h1.getDeps().values()) {
                if (d.getEntries().isEmpty() || d.isReplaced()) continue;
                out.printf(" %s", this.getHotfixLink(d.getTo()));
                hasDeps = true;
            }
            if (!hasDeps) {
                out.printf(" //none// ", new Object[0]);
            }
            out.printf("|%n", new Object[0]);
            out.printf("| Replacements |", new Object[0]);
            hasDeps = false;
            for (Hotfix.Dependency d : h1.getDeps().values()) {
                if (d.getEntries().isEmpty() || !d.isReplaced()) continue;
                out.printf(" %s", this.getHotfixLink(d.getTo()));
                hasDeps = true;
            }
            if (!hasDeps) {
                out.printf(" //none// ", new Object[0]);
            }
            out.printf("|%n%nDetails%n", new Object[0]);
            hasDeps = false;
            for (Hotfix.Dependency d : h1.getDeps().values()) {
                if (d.getEntries().isEmpty()) continue;
                hasDeps = true;
                String type = "";
                if (d.isReplaced()) {
                    type = "replaces ";
                }
                out.printf("* %s%s (has %d files; %d overlap, %d more, %d less)%n", type, this.getHotfixLink(d.getTo()), d.getTotal(), d.getEntries().size(), d.getAdded(), d.getAbsent());
                for (String name : d.getEntries().keySet()) {
                    Version[] vs = d.getEntries().get(name);
                    if (vs[0].equals(Hotfix.VX) && vs[1].equals(Hotfix.VX)) {
                        out.printf("** %s (different)%n", name);
                        continue;
                    }
                    out.printf("** %s-%s (%s)%n", name, vs[1], vs[0]);
                }
            }
            if (hasDeps) continue;
            out.printf("//no dependencies//%n", new Object[0]);
        }
        out.close();
        System.out.println("done.");
    }

    private String getHotfixLink(Hotfix h) {
        String name = h.getId();
        int idx = name.lastIndexOf(45);
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        return h.isFeaturepack() ? String.format(this.linkFeaturepackFormat, name, h.getId()) : String.format(this.linkHotfixFormat, name, h.getId());
    }
}

