/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.hotfix;

import com.day.jcr.vault.packaging.Version;
import com.day.jcr.vault.packaging.hotfix.Hotfix;
import com.day.jcr.vault.util.MD5;

public class Entry {
    private final String path;
    private final String name;
    private final Version version;
    private final MD5 md5;

    public Entry(String path, MD5 md5) {
        this.md5 = md5;
        this.path = path;
        String n = path.substring(path.lastIndexOf(47) + 1);
        int idx = n.lastIndexOf(46);
        if (idx < 0) {
            this.name = n;
            this.version = Hotfix.VX;
        } else {
            int idx2 = n.lastIndexOf(45, idx);
            if (idx2 < 0) {
                this.name = n;
                this.version = Hotfix.VX;
            } else {
                String v = n.substring(idx2 + 1, idx);
                if (v.equals("SNAPSHOT") || v.startsWith("R")) {
                    idx2 = n.lastIndexOf(45, idx2 - 1);
                    v = n.substring(idx2 + 1, idx);
                }
                this.name = n.substring(0, idx2);
                this.version = new Version(v);
            }
        }
    }

    public String toString() {
        return this.path + "; name=" + this.name + "; v=" + this.version;
    }

    public String getId() {
        return this.path.substring(0, this.path.lastIndexOf(47) + 1) + this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public MD5 getMd5() {
        return this.md5;
    }
}

