/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.hotfix;

import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.DefaultMetaInf;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.fs.io.ZipArchive;
import com.day.jcr.vault.packaging.Version;
import com.day.jcr.vault.packaging.hotfix.Entry;
import com.day.jcr.vault.util.MD5;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.util.ISO8601;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hotfix {
    public static final Version VX = Version.create("x");
    private MetaInf inf = new DefaultMetaInf();
    private final String name;
    private Calendar created;
    private Map<String, Entry> entries = new HashMap<String, Entry>();
    private final String id;
    private boolean featurepack;
    private TreeMap<String, Dependency> deps = new TreeMap();

    public Hotfix(String name) {
        this.name = name;
        String s = name.substring(0, name.lastIndexOf(46));
        int idx = s.indexOf("hotfix-");
        if (idx > 0) {
            this.id = s.substring(idx + 7);
            return;
        }
        idx = s.indexOf("featurepack-");
        if (idx > 0) {
            this.id = s.substring(idx + 12);
            this.featurepack = true;
            return;
        }
        Entry fake = new Entry(name, null);
        this.id = fake.getVersion().toString();
    }

    public void scan(File file) throws IOException, ConfigurationException {
        String c;
        System.out.printf("Scanning %s%n", file.getPath());
        ZipArchive archive = new ZipArchive(file);
        archive.open(false);
        this.inf = archive.getMetaInf();
        if (this.inf.getProperties() != null && (c = this.inf.getProperties().getProperty("created")) != null) {
            this.created = ISO8601.parse((String)c);
        }
        if (this.created == null) {
            this.created = Calendar.getInstance();
            this.created.setTimeInMillis(file.lastModified());
        }
        this.traverse(archive, archive.getJcrRoot(), "");
        archive.close();
    }

    private void traverse(Archive archive, Archive.Entry parent, String parentPath) throws IOException {
        for (Archive.Entry entry : parent.getChildren()) {
            String path = parentPath + "/" + entry.getName();
            if (entry.isDirectory()) {
                this.traverse(archive, entry, path);
                continue;
            }
            String checkPath = path;
            if (entry.getName().equals(".content.xml")) {
                checkPath = parentPath;
            } else if (entry.getName().endsWith(".xml")) {
                checkPath = path.substring(0, path.length() - 4);
            }
            if (this.inf.getFilter().contains(checkPath)) {
                MD5 md5 = MD5.digest(archive.getInputSource(entry).getByteStream());
                Entry he = new Entry(path, md5);
                System.out.printf("A %s (%s)%n", he, md5);
                this.entries.put(he.getId(), he);
                continue;
            }
            System.out.printf("- %s%n", path);
        }
    }

    public void resolveDependencies(Hotfix h) {
        long c2;
        if (h.equals(this)) {
            return;
        }
        long c1 = this.created == null ? 0L : this.created.getTimeInMillis();
        long l = c2 = h.created == null ? 0L : h.created.getTimeInMillis();
        if (c2 > c1) {
            return;
        }
        boolean isOlder = false;
        boolean isNewer = false;
        Dependency d = new Dependency(this, h);
        this.deps.put(h.getId(), d);
        for (Entry e1 : this.entries.values()) {
            Entry e2 = h.getEntries().get(e1.getId());
            if (e2 != null) {
                Version v1 = e1.getVersion();
                Version v2 = e2.getVersion();
                if (v1.equals(VX) || v2.equals(VX)) {
                    MD5 m1 = e1.getMd5();
                    MD5 m2 = e2.getMd5();
                    if (m1 != null && m2 != null && m1.equals(m2)) continue;
                    isOlder = true;
                    d.entries.put(e1.getId(), new Version[]{v1, v2});
                    continue;
                }
                int c = v1.compareTo(v2);
                if (c < 0) {
                    d.entries.put(e1.getId(), new Version[]{v1, v2});
                    isNewer = true;
                    continue;
                }
                if (c <= 0) continue;
                d.entries.put(e1.getId(), new Version[]{v1, v2});
                isOlder = true;
                continue;
            }
            d.incAbsent();
        }
        for (Entry e2 : h.getEntries().values()) {
            if (this.entries.containsKey(e2.getId())) continue;
            d.incAdded();
        }
        if (d.getAdded() == 0 && isOlder) {
            d.setReplaced(true);
        }
    }

    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFeaturepack() {
        return this.featurepack;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    public TreeMap<String, Dependency> getDeps() {
        return this.deps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dependency {
        private final Hotfix from;
        private final Hotfix to;
        private Map<String, Version[]> entries = new HashMap<String, Version[]>();
        private int added;
        private int absent;
        private boolean replaced;
        private boolean replacedBy;

        public Dependency(Hotfix from, Hotfix to) {
            this.from = from;
            this.to = to;
        }

        public Map<String, Version[]> getEntries() {
            return this.entries;
        }

        public Hotfix getFrom() {
            return this.from;
        }

        public Hotfix getTo() {
            return this.to;
        }

        public boolean isReplaced() {
            return this.replaced;
        }

        public void setReplaced(boolean replaced) {
            this.replaced = replaced;
        }

        public void incAdded() {
            ++this.added;
        }

        public int getAdded() {
            return this.added;
        }

        public void incAbsent() {
            ++this.absent;
        }

        public int getAbsent() {
            return this.absent;
        }

        public int getTotal() {
            return this.entries.size() + this.added;
        }
    }
}

