/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(AdminPermissionChecker.class);
    private static final String ADMIN_USER = "admin";
    private static final String SYSTEM_USER = "system";
    private static final String ADMINISTRATORS_GROUP = "administrators";

    public static boolean hasAdministrativePermissions(Session session) throws RepositoryException {
        String userId = session.getUserID();
        boolean isAdministrator = ADMIN_USER.equals(userId) || SYSTEM_USER.equals(userId);
        boolean isJackrabbitSession = session instanceof JackrabbitSession;
        if (!isAdministrator) {
            if (isJackrabbitSession) {
                JackrabbitSession jackrabbitSession = (JackrabbitSession)session;
                Authorizable authorizable = jackrabbitSession.getUserManager().getAuthorizable(userId);
                Iterator groupIterator = authorizable.memberOf();
                while (groupIterator.hasNext()) {
                    if (!ADMINISTRATORS_GROUP.equals(((Group)groupIterator.next()).getID())) continue;
                    isAdministrator = true;
                    break;
                }
            } else {
                log.warn("could not evaluate group permissions but just user name");
            }
        }
        return isAdministrator;
    }
}

