/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.packaging.JcrPackage;
import com.day.jcr.vault.packaging.impl.JcrPackageManagerImpl;
import com.day.jcr.vault.packaging.impl.PackageManagerMBean;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManagerMBeanImpl
extends StandardMBean
implements PackageManagerMBean {
    private static final Logger log = LoggerFactory.getLogger(PackageManagerMBeanImpl.class);
    private SlingRepository repository;
    private static final String[] packageItemNames = new String[]{"id", "size", "installed", "installedDate", "installedBy"};
    private static final String[] packageItemDescriptions = new String[]{"Package Id", "Package Size", "Is installed", "Install Date", "Install User"};
    private static final OpenType[] packageItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.BOOLEAN, SimpleType.DATE, SimpleType.STRING};
    private static final String[] packageIndexNames = new String[]{"id"};
    private final CompositeType packageType = new CompositeType("package", "Package Info", packageItemNames, packageItemDescriptions, packageItemTypes);
    private final TabularType packageTabularType = new TabularType("packages", "List of Packages", this.packageType, packageIndexNames);

    public PackageManagerMBeanImpl() throws NotCompliantMBeanException, OpenDataException {
        super(PackageManagerMBean.class);
    }

    protected String getDescription(MBeanInfo info) {
        return "Package Manager Information";
    }

    protected String getDescription(MBeanAttributeInfo info) {
        if (info.getName().equals("Packages")) {
            return "Available Packages";
        }
        return super.getDescription(info);
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] ctors, Object impl) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabularData getPackages() {
        TabularDataSupport packageData = new TabularDataSupport(this.packageTabularType);
        if (this.repository != null) {
            Session session = null;
            try {
                session = this.repository.loginAdministrative(null);
                JcrPackageManagerImpl pkgMgr = new JcrPackageManagerImpl(session);
                for (JcrPackage pkg : pkgMgr.listPackages()) {
                    try {
                        Object[] values = new Object[]{pkg.getDefinition().getId().toString(), pkg.getSize(), pkg.isInstalled(), pkg.getDefinition().getLastUnpacked() == null ? null : pkg.getDefinition().getLastUnpacked().getTime(), pkg.getDefinition().getLastUnpackedBy()};
                        packageData.put(new CompositeDataSupport(this.packageType, packageItemNames, values));
                    }
                    catch (Exception e) {
                        log.warn("Can't add composite data", (Throwable)e);
                    }
                    pkg.close();
                }
            }
            catch (RepositoryException e) {
                log.error("Repository error while retrieving package list", (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        } else {
            log.warn("Unable to provide package list. Repository not bound.");
        }
        return packageData;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

