/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.apache.maven.plugin.logging.Log;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.StaticLoggerBinder;

public class MavenLoggerAdapter
extends MarkerIgnoringBase {
    private static boolean logInfoAtDebugLevel = true;

    public static void logInfoAtDebugLevel(boolean v) {
        logInfoAtDebugLevel = v;
    }

    private Log log() {
        return StaticLoggerBinder.getSingleton().getMavenLog();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(String msg) {
        this.log().debug((CharSequence)msg);
    }

    public void trace(String format, Object arg) {
        this.log().debug((CharSequence)this.format(format, arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log().debug((CharSequence)this.format(format, arg1, arg2));
    }

    public void trace(String format, Object[] argArray) {
        this.log().debug((CharSequence)this.format(format, argArray));
    }

    public void trace(String msg, Throwable thr) {
        this.log().debug((CharSequence)msg, thr);
    }

    public boolean isDebugEnabled() {
        return this.log().isDebugEnabled();
    }

    public void debug(String msg) {
        this.log().debug((CharSequence)msg);
    }

    public void debug(String format, Object arg) {
        this.log().debug((CharSequence)this.format(format, arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log().debug((CharSequence)this.format(format, arg1, arg2));
    }

    public void debug(String format, Object[] argArray) {
        this.log().debug((CharSequence)this.format(format, argArray));
    }

    public void debug(String msg, Throwable thr) {
        this.log().debug((CharSequence)msg, thr);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        if (!logInfoAtDebugLevel) {
            this.log().info((CharSequence)msg);
        } else {
            this.log().debug((CharSequence)msg);
        }
    }

    public void info(String format, Object arg) {
        if (!logInfoAtDebugLevel) {
            this.log().info((CharSequence)this.format(format, arg));
        } else {
            this.log().debug((CharSequence)this.format(format, arg));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (!logInfoAtDebugLevel) {
            this.log().info((CharSequence)this.format(format, arg1, arg2));
        } else {
            this.log().debug((CharSequence)this.format(format, arg1, arg2));
        }
    }

    public void info(String format, Object[] argArray) {
        if (!logInfoAtDebugLevel) {
            this.log().info((CharSequence)this.format(format, argArray));
        } else {
            this.log().debug((CharSequence)this.format(format, argArray));
        }
    }

    public void info(String msg, Throwable thr) {
        if (!logInfoAtDebugLevel) {
            this.log().info((CharSequence)msg, thr);
        } else {
            this.log().info((CharSequence)msg, thr);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.log().warn((CharSequence)msg);
    }

    public void warn(String format, Object arg) {
        this.log().warn((CharSequence)this.format(format, arg));
    }

    public void warn(String format, Object[] argArray) {
        this.log().warn((CharSequence)this.format(format, argArray));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log().warn((CharSequence)this.format(format, arg1, arg2));
    }

    public void warn(String msg, Throwable thr) {
        this.log().warn((CharSequence)msg, thr);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.log().error((CharSequence)msg);
    }

    public void error(String format, Object arg) {
        this.log().error((CharSequence)this.format(format, arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log().error((CharSequence)this.format(format, arg1, arg2));
    }

    public void error(String format, Object[] argArray) {
        this.log().error((CharSequence)this.format(format, argArray));
    }

    public void error(String msg, Throwable thr) {
        this.log().error((CharSequence)msg, thr);
    }

    private String format(String format, Object arg) {
        return MessageFormatter.format((String)format, (Object)arg);
    }

    private String format(String format, Object arg1, Object arg2) {
        return MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
    }

    private String format(String format, Object[] argArray) {
        return MessageFormatter.format((String)format, (Object)argArray);
    }
}

