/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "com.day.jcr.vault:content-package-maven-plugin:0.0.24", 0);
        this.append(sb, "", 0);
        this.append(sb, "Adobe Content Package Maven Plugin", 0);
        this.append(sb, "Maven Plugin supporting creation of content packages and controlling the package manager on a remote system.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 10 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "build".equals(this.goal)) {
            this.append(sb, "content-package:build", 0);
            this.append(sb, "Builds a content package defined on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "If true, fail the build if there is an error while executing.", 3);
                this.append(sb, "Expression: ${vault.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The group of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.group}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.name}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path", 2);
                this.append(sb, "The path of the package to build on the target system.", 3);
                this.append(sb, "Expression: ${vault.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxedSSLCheck (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.relaxedSSLCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "Expression: ${vault.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceURL (Default: http://localhost:4502/crx/packmgr/service/.json)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.serviceURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.targetURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "Expression: ${vault.timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "Expression: ${vault.useProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.userId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "Expression: ${vault.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.version}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "check-signature".equals(this.goal)) {
            this.append(sb, "content-package:check-signature", 0);
            this.append(sb, "Maven goal which checks the embedded libraries against a defined signature. Based on the Animal Sniffer project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "embeddeds", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnMissingEmbed (Default: false)", 2);
                this.append(sb, "Defines whether to fail the build when an embedded artifact is not found in the project's dependencies", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.failOnMissingEmbed}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignores", 2);
                this.append(sb, "Class names to ignore signatures for (wildcards accepted).", 3);
                this.append(sb, "", 0);
                this.append(sb, "signature", 2);
                this.append(sb, "Signature module to use.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "download".equals(this.goal)) {
            this.append(sb, "content-package:download", 0);
            this.append(sb, "Downloads a content package defined on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "If true, fail the build if there is an error while building.", 3);
                this.append(sb, "Expression: ${vault.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile", 2);
                this.append(sb, "The output file to save.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.outputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path", 2);
                this.append(sb, "The path of the package on the target system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxedSSLCheck (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.relaxedSSLCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "Expression: ${vault.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceURL (Default: http://localhost:4502/crx/packmgr/service/.json)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.serviceURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.targetURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "Expression: ${vault.timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "Expression: ${vault.useProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.userId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "Expression: ${vault.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "content-package:help", 0);
            this.append(sb, "Display help information on content-package-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0content-package:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install".equals(this.goal)) {
            this.append(sb, "content-package:install", 0);
            this.append(sb, "Install a Content Package on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifact", 2);
                this.append(sb, "A string of the form groupId:artifactId:version[:packaging].", 3);
                this.append(sb, "Expression: ${vault.artifact}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactId", 2);
                this.append(sb, "The artifactId of the artifact to install", 3);
                this.append(sb, "Expression: ${vault.artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "If true, fail the build if there is an error while installing.", 3);
                this.append(sb, "Expression: ${vault.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupId", 2);
                this.append(sb, "The groupId of the artifact to install", 3);
                this.append(sb, "Expression: ${vault.groupId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "install (Default: true)", 2);
                this.append(sb, "Whether to install (unpack) the uploaded package automatically or not.", 3);
                this.append(sb, "Expression: ${vault.install}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name (Default: ${project.artifactId})", 2);
                this.append(sb, "The name of the content package", 3);
                this.append(sb, "Expression: ${vault.name}", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageFile (Default: ${project.build.directory}/${project.build.finalName}.zip)", 2);
                this.append(sb, "The name of the content package file to install on the target system. If not set, the primary artifact of the project is considered the content package to be installed.", 3);
                this.append(sb, "Expression: ${vault.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "packaging (Default: zip)", 2);
                this.append(sb, "The packaging of the artifact to install", 3);
                this.append(sb, "Expression: ${vault.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxedSSLCheck (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.relaxedSSLCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryId (Default: temp)", 2);
                this.append(sb, "The id of the repository from which we'll download the artifact", 3);
                this.append(sb, "Expression: ${vault.repoId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryUrl", 2);
                this.append(sb, "The url of the repository from which we'll download the artifact", 3);
                this.append(sb, "Expression: ${vault.repoUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "Expression: ${vault.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceURL (Default: http://localhost:4502/crx/packmgr/service/.json)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.serviceURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.targetURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "Expression: ${vault.timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "Expression: ${vault.useProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.userId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "Expression: ${vault.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the artifact to install", 3);
                this.append(sb, "Expression: ${vault.version}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "ls".equals(this.goal)) {
            this.append(sb, "content-package:ls", 0);
            this.append(sb, "Lists packages installed on remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "If true, fail the build if there is an error getting the package list.", 3);
                this.append(sb, "Expression: ${vault.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxedSSLCheck (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.relaxedSSLCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "Expression: ${vault.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceURL (Default: http://localhost:4502/crx/packmgr/service/.json)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.serviceURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.targetURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "Expression: ${vault.timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "Expression: ${vault.useProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.userId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "Expression: ${vault.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "package".equals(this.goal)) {
            this.append(sb, "content-package:package", 0);
            this.append(sb, "Build a content package.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See the documentation for Maven Archiver.", 3);
                this.append(sb, "", 0);
                this.append(sb, "builtContentDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The directory containing the content to be packaged up into the content package.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependencies", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "embeddeds", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "embeddedTarget", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.embeddedTarget}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnMissingEmbed (Default: false)", 2);
                this.append(sb, "Defines whether to fail the build when an embedded artifact is not found in the project's dependencies", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.failOnMissingEmbed}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Defines the content of the filter.xml file", 3);
                this.append(sb, "", 0);
                this.append(sb, "filterSource", 2);
                this.append(sb, "Optional file that specifies the source of the workspace filter. The filters specified in the configuration and injected via emebedds or subpackages are merged into it.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated package ZIP file without the '.zip' file extension.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "group (Default: ${project.groupId})", 2);
                this.append(sb, "The groupId used for the generated content package. This will be part of the target installation path of the content package.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.group}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name (Default: ${project.artifactId})", 2);
                this.append(sb, "The name of the content package", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.name}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Directory in which the built content package will be output.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.prefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Specifies additional properties to be set in the properties.xml file. These properties cannot overwrite the following predefined properties: \ngroup\nUse group parameter to set\nname\nUse name parameter to set\nversion\nUse version parameter to set\ngroupId\ngroupId of the Maven project descriptor\nartifactId\nartifactId of the Maven project descriptor\ndependencies\nUse dependencies parameter to set\ncreatedBy\nThe value of the user.name system property\ncreated\nThe current system time\nrequiresRoot\nUse requiresRoot parameter to set\npackagePath\nAutomatically generated from the group and package name", 3);
                this.append(sb, "", 0);
                this.append(sb, "requiresRoot (Default: false)", 2);
                this.append(sb, "Defines whether the package requires root. This will become the requiresRoot property of the properties.xml file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.requiresRoot}", 3);
                this.append(sb, "", 0);
                this.append(sb, "subPackages", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: ${project.version})", 2);
                this.append(sb, "The version of the content package.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.version}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory (Default: ${project.build.directory}/vault-work)", 2);
                this.append(sb, "The directory containing the content to be packaged up into the content package.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "replicate".equals(this.goal)) {
            this.append(sb, "content-package:replicate", 0);
            this.append(sb, "Replicates a content package defined on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "If true, fail the build if there is an error while building.", 3);
                this.append(sb, "Expression: ${vault.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path", 2);
                this.append(sb, "The path of the package to build on the target system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxedSSLCheck (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.relaxedSSLCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "Expression: ${vault.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceURL (Default: http://localhost:4502/crx/packmgr/service/.json)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.serviceURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.targetURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "Expression: ${vault.timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "Expression: ${vault.useProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.userId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "Expression: ${vault.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rm".equals(this.goal)) {
            this.append(sb, "content-package:rm", 0);
            this.append(sb, "Removes a content package installed on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "If true, fail the build if there is an error while executing.", 3);
                this.append(sb, "Expression: ${vault.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The group of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.group}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.name}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path", 2);
                this.append(sb, "The path of the package to build on the target system.", 3);
                this.append(sb, "Expression: ${vault.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxedSSLCheck (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.relaxedSSLCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "Expression: ${vault.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceURL (Default: http://localhost:4502/crx/packmgr/service/.json)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.serviceURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.targetURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "Expression: ${vault.timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "Expression: ${vault.useProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.userId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "Expression: ${vault.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.version}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "uninstall".equals(this.goal)) {
            this.append(sb, "content-package:uninstall", 0);
            this.append(sb, "Uninstalls a content package installed on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: false)", 2);
                this.append(sb, "If true, fail the build if there is an error while executing.", 3);
                this.append(sb, "Expression: ${vault.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The group of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.group}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.name}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path", 2);
                this.append(sb, "The path of the package to build on the target system.", 3);
                this.append(sb, "Expression: ${vault.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "relaxedSSLCheck (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${vault.relaxedSSLCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "Expression: ${vault.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceURL (Default: http://localhost:4502/crx/packmgr/service/.json)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.serviceURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.targetURL}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "Expression: ${vault.timeout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "Expression: ${vault.useProxy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${vault.userId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "Expression: ${vault.verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the package on the target system.", 3);
                this.append(sb, "Expression: ${vault.version}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

