/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import com.day.jcr.vault.maven.mgr.AbstractPackageManagerMojo;
import com.day.jcr.vault.maven.mgr.Command;
import java.util.ArrayList;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.sling.commons.json.JSONObject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

abstract class AbstractNameOrPathPackageManagerMojo
extends AbstractPackageManagerMojo {
    private static final String PATH_FORMAT = "/etc/packages/%s/%s-%s.zip";
    private String group;
    private String name;
    private String path;
    private String version;
    private boolean failOnError;

    AbstractNameOrPathPackageManagerMojo() {
    }

    protected abstract String getLegacyCommandName();

    protected abstract Command getCommand();

    protected abstract String getInfoMessageFormat();

    protected abstract String getErrorMessage();

    protected void logSuccess(String description, String targetUrl) {
        this.getLog().info((CharSequence)String.format(this.getInfoMessageFormat(), description, targetUrl));
    }

    protected static String constructPath(String group, String name, String version) {
        return String.format(PATH_FORMAT, group, name, version);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.name != null) {
            if (this.group != null && this.version != null) {
                this.executeOnPath(AbstractNameOrPathPackageManagerMojo.constructPath(this.group, this.name, this.version));
            } else {
                Xpp3Dom result;
                ArrayList<Part> parts = new ArrayList<Part>();
                String displayName = this.name;
                parts.add((Part)new StringPart("name", this.name));
                if (this.group != null) {
                    displayName = this.group + ":" + displayName;
                    parts.add((Part)new StringPart("group", this.group));
                }
                if (this.checkStatus(result = this.postRequest(this.getLegacyCommandName(), parts))) {
                    this.logSuccess(displayName, this.getTargetURL());
                } else if (this.failOnError) {
                    throw new MojoFailureException(this.getErrorMessage());
                }
            }
        } else if (this.path != null) {
            this.executeOnPath(this.path);
        } else {
            throw new MojoExecutionException("Either name or path must be specified.");
        }
    }

    private void executeOnPath(String packagePath) throws MojoExecutionException, MojoFailureException {
        JSONObject result = this.postRequest(this.getCommand(), packagePath);
        if (this.checkStatus(result)) {
            this.logSuccess(packagePath, this.getTargetURL(packagePath, this.getCommand()));
        } else if (this.failOnError) {
            throw new MojoFailureException(this.getErrorMessage());
        }
    }
}

