/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import com.day.jcr.vault.maven.mgr.Command;
import com.day.jcr.vault.maven.mgr.ssl.EasySSLProtocolSocketFactory;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPackageManagerMojo
extends AbstractMojo {
    private Settings settings;
    private String targetURL;
    private String serviceURL;
    private String userId;
    private String password;
    private String serverId;
    private boolean verbose;
    private int timeout;
    private boolean useProxy;
    private boolean relaxedSSLCheck;
    private SecDispatcher securityDispatcher;

    AbstractPackageManagerMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.relaxedSSLCheck) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
        }
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public String getUserId() {
        if (this.serverId != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                throw new IllegalArgumentException(String.format("Server ID %s does not exist in settings.xml.", this.serverId));
            }
            return server.getUsername();
        }
        return this.userId;
    }

    public String getPassword() throws SecDispatcherException {
        if (this.serverId != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                throw new IllegalArgumentException(String.format("Server ID %s does not exist in settings.xml.", this.serverId));
            }
            return this.securityDispatcher.decrypt(server.getPassword());
        }
        return this.password;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getTimoutMs() {
        return 1000 * this.timeout;
    }

    protected Xpp3Dom postRequest(String command, Collection<Part> parameters) throws MojoExecutionException {
        if (parameters == null) {
            parameters = new ArrayList<Part>();
        }
        if (command != null) {
            parameters.add((Part)new StringPart("cmd", command));
        }
        if (parameters.isEmpty()) {
            this.getLog().error((CharSequence)("Not POSTing to " + this.getTargetURL() + ": Missing parameters"));
            return null;
        }
        PostMethod filePost = new PostMethod(this.getTargetURL());
        filePost.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        filePost.setRequestHeader("referer", "about:blank");
        try {
            Part[] parts = new Part[parameters.size()];
            parameters.toArray(parts);
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            HttpClient client = new HttpClient();
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getUserId(), this.getPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.setupProxy(client);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimoutMs());
            int status = client.executeMethod((HttpMethod)filePost);
            if (status == 200) {
                Xpp3Dom dom;
                StringWriter out = new StringWriter();
                InputStreamReader in = new InputStreamReader(filePost.getResponseBodyAsStream(), filePost.getRequestCharSet());
                IOUtil.copy((Reader)in, (Writer)out);
                String ret = out.toString();
                try {
                    dom = Xpp3DomBuilder.build((Reader)new StringReader(ret));
                }
                catch (XmlPullParserException e) {
                    Matcher m = Pattern.compile("<log>(.*)</log>", 32).matcher(ret);
                    StringBuffer result = new StringBuffer();
                    while (m.find()) {
                        String log = "<log><![CDATA[" + m.group(1) + "]]></log>";
                        m.appendReplacement(result, Matcher.quoteReplacement(log));
                    }
                    m.appendTail(result);
                    ret = result.toString();
                    dom = Xpp3DomBuilder.build((Reader)new StringReader(ret));
                }
                Xpp3Dom xpp3Dom = dom;
                return xpp3Dom;
            }
            this.getLog().error((CharSequence)("Request to " + this.getTargetURL() + " failed, response=" + HttpStatus.getStatusText((int)status)));
            Xpp3Dom xpp3Dom = null;
            return xpp3Dom;
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected JSONObject postRequest(Command command, String path) throws MojoExecutionException {
        if (command == null) {
            this.getLog().error((CharSequence)"command was null. Not POSTing.");
            return null;
        }
        if (path == null) {
            this.getLog().error((CharSequence)"path was null. Not POSTing.");
            return null;
        }
        String url = this.getTargetURL(path, command);
        this.getLog().info((CharSequence)("POSTing to " + url));
        PostMethod post = new PostMethod(url);
        post.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        post.setRequestHeader("referer", "about:blank");
        try {
            HttpClient client = new HttpClient();
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getUserId(), this.getPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.setupProxy(client);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimoutMs());
            int status = client.executeMethod((HttpMethod)post);
            if (status == 200) {
                StringWriter out = new StringWriter();
                InputStreamReader in = new InputStreamReader(post.getResponseBodyAsStream(), post.getRequestCharSet());
                IOUtil.copy((Reader)in, (Writer)out);
                String ret = out.toString();
                JSONObject jSONObject = new JSONObject(ret);
                return jSONObject;
            }
            this.getLog().error((CharSequence)("Request to " + url + " failed, response=" + HttpStatus.getStatusText((int)status)));
            JSONObject jSONObject = null;
            return jSONObject;
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    protected String getTargetURL(String path, Command command) {
        return String.format("%s%s?cmd=%s", this.serviceURL, path, command.getQueryParamValue());
    }

    protected void setupProxy(HttpClient client) {
        List proxies = this.settings.getProxies();
        if (this.useProxy && proxies != null && !proxies.isEmpty()) {
            this.getLog().debug((CharSequence)("Considering " + proxies.size() + " proxies"));
            for (Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                this.getLog().debug((CharSequence)("Using proxy " + proxy.getHost() + ":" + proxy.getPort()));
                client.getHostConfiguration().setProxy(proxy.getHost(), proxy.getPort());
                if (proxy.getUsername() != null) {
                    UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                    client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)proxyCredentials);
                }
                break;
            }
        } else {
            this.getLog().debug((CharSequence)("Proxying disabled (useProxy=" + this.useProxy + ") or no proxies configured"));
        }
    }

    protected Xpp3Dom getNestedChild(Xpp3Dom element, String path) {
        String[] parts = path.split("/");
        Xpp3Dom current = element;
        for (int i = 0; i < parts.length && current != null; current = current.getChild(parts[i]), ++i) {
        }
        return current;
    }

    protected String getText(Xpp3Dom parent, String childName) {
        Xpp3Dom child;
        Xpp3Dom xpp3Dom = child = childName == null ? parent : parent.getChild(childName);
        if (child != null) {
            return child.getValue();
        }
        return parent.getAttribute(childName);
    }

    protected boolean checkStatus(Xpp3Dom result) {
        if (result == null) {
            return false;
        }
        Xpp3Dom status = this.getNestedChild(result, "response/status");
        if (status == null) {
            this.getLog().error((CharSequence)("Missing response status information in response: " + result));
            return false;
        }
        String code = this.getText(status, "code");
        if ("200".equals(code)) {
            this.getLog().debug((CharSequence)"Request succeeded");
            return true;
        }
        this.getLog().error((CharSequence)("Request failed: " + this.getText(status, null) + " (" + this.getText(status, "code") + ")"));
        return false;
    }

    protected boolean checkStatus(JSONObject result) throws MojoExecutionException {
        if (result == null) {
            return false;
        }
        if (result.has("success")) {
            try {
                boolean success = result.getBoolean("success");
                if (success) {
                    this.getLog().debug((CharSequence)"Request succeeded");
                    return true;
                }
                String msg = result.has("msg") ? result.getString("msg") : "Unknown error. Full JSON response: " + result.toString(2);
                this.getLog().error((CharSequence)("Request failed: " + msg));
                return false;
            }
            catch (JSONException e) {
                throw new MojoExecutionException("Usparsable JSON Object", (Exception)((Object)e));
            }
        }
        this.getLog().error((CharSequence)("Missing response status information in response: " + result));
        return false;
    }

    protected void logPackage(Xpp3Dom pkg) {
        if (pkg != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getText(pkg, "group"));
            buf.append(":");
            buf.append(this.getText(pkg, "name"));
            String version = this.getText(pkg, "version");
            if (version != null && version.length() > 0) {
                buf.append(", ");
                buf.append(version);
            }
            buf.append(" (");
            buf.append(this.getText(pkg, "size"));
            buf.append(" bytes)");
            this.getLog().info((CharSequence)buf);
            if (this.isVerbose()) {
                this.logPackageDate(pkg, "Created ", "created");
                this.logPackageDate(pkg, "Modified", "lastModified");
                this.logPackageDate(pkg, "Unpacked", "lastUnpacked");
                this.getLog().info((CharSequence)"");
            }
        }
    }

    private void logPackageDate(Xpp3Dom pkg, String label, String kind) {
        String user = this.getText(pkg, kind + "By");
        StringBuilder builder = new StringBuilder();
        builder.append("    ").append(label).append(": ");
        if (user != null && !user.equals("null")) {
            builder.append(this.getText(pkg, kind)).append(" by ").append(user);
        } else {
            builder.append("-");
        }
        this.getLog().info((CharSequence)builder);
    }
}

