/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import com.day.jcr.vault.maven.mgr.AbstractPackageManagerMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="ls", requiresProject=false)
public class PackageListMojo
extends AbstractPackageManagerMojo {
    @Parameter(property="vault.failOnError", defaultValue="false")
    private boolean failOnError;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Xpp3Dom result = this.postRequest("ls", null);
        if (this.checkStatus(result)) {
            Xpp3Dom packages = this.getNestedChild(result, "response/data/packages");
            if (packages == null) {
                this.getLog().info((CharSequence)"No packages installed");
            } else {
                Xpp3Dom[] packageList;
                this.getLog().info((CharSequence)("Packages installed at " + this.getTargetURL()));
                for (Xpp3Dom aPackageList : packageList = packages.getChildren("package")) {
                    this.logPackage(aPackageList);
                }
            }
        } else if (this.failOnError) {
            throw new MojoFailureException("Error getting package list. Check log for details.");
        }
    }
}

