/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.config;

import com.day.jcr.vault.fs.api.Aggregator;
import com.day.jcr.vault.fs.api.ArtifactHandler;
import com.day.jcr.vault.fs.api.ItemFilter;
import com.day.jcr.vault.fs.api.ItemFilterSet;
import com.day.jcr.vault.fs.config.AbstractVaultFsConfig;
import com.day.jcr.vault.fs.config.ConfigHelper;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.Registry;
import com.day.jcr.vault.fs.filter.IsMandatoryFilter;
import com.day.jcr.vault.fs.filter.IsNodeFilter;
import com.day.jcr.vault.fs.filter.NameItemFilter;
import com.day.jcr.vault.fs.filter.NodeTypeItemFilter;
import com.day.jcr.vault.fs.impl.aggregator.GenericAggregator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class VaultFsConfig11
extends AbstractVaultFsConfig {
    private static final Logger log = LoggerFactory.getLogger(VaultFsConfig11.class);
    public static final double SUPPORTED_VERSION = 1.1;
    private final ConfigHelper helper = new ConfigHelper();

    public VaultFsConfig11() {
        this.helper.getDefaultPackages().put("include", "com.day.jcr.vault.fs.filter");
        this.helper.getDefaultPackages().put("exclude", "com.day.jcr.vault.fs.filter");
        Map<String, String> m = this.helper.getMappings();
        m.put("com.day.jcr.vault.fs.imprt.FolderArtifactHandler", "com.day.jcr.vault.fs.impl.io.FileArtifactHandler");
        m.put("com.day.jcr.vault.fs.imprt.FileArtifactHandler", "com.day.jcr.vault.fs.impl.io.FileArtifactHandler");
        m.put("com.day.jcr.vault.fs.imprt.GenericArtifactHandler", "com.day.jcr.vault.fs.impl.io.GenericArtifactHandler");
        m.put("com.day.jcr.vault.fs.imprt.NodeTypeArtifactHandler", "com.day.jcr.vault.fs.impl.io.NodeTypeArtifactHandler");
        m.put("com.day.jcr.vault.fs.filter.ItemFilter", "com.day.jcr.vault.fs.api.ItemFilter");
        m.put("com.day.jcr.vault.fs.filter.PathFilter", "com.day.jcr.vault.fs.api.PathFilter");
    }

    protected void process(Element elem) throws ConfigurationException {
        for (Element child : VaultFsConfig11.getChildElements(elem)) {
            if (child.getNodeName().equals("aggregates")) {
                for (Element agg : VaultFsConfig11.getChildElements(child)) {
                    if (agg.getNodeName().equals("aggregate")) {
                        this.processAggregate(agg);
                        continue;
                    }
                    log.warn("Unkown element name in config: " + agg.getNodeName());
                }
                continue;
            }
            if (child.getNodeName().equals("handlers")) {
                for (Element handler : VaultFsConfig11.getChildElements(child)) {
                    if (handler.getNodeName().equals("handler")) {
                        this.processHandler(handler);
                        continue;
                    }
                    log.warn("Unkown element name in config: " + handler.getNodeName());
                }
                continue;
            }
            log.warn("Unkown element name in config: " + child.getNodeName());
        }
    }

    private void processAggregate(Element elem) throws ConfigurationException {
        Aggregator aggregator;
        String type = elem.getAttribute("type");
        if (type == null || type.equals("")) {
            type = "generic";
        }
        if ((aggregator = Registry.getInstance().createAggregator(type)) == null) {
            this.fail("Aggregator of type " + type + " is not registered.", elem);
        }
        if (aggregator instanceof GenericAggregator) {
            GenericAggregator ga = (GenericAggregator)aggregator;
            String title = elem.getAttribute("title");
            if (title != null) {
                ga.setName(title);
            }
            if ("true".equals(elem.getAttribute("isDefault"))) {
                ga.setIsDefault("true");
            }
            for (Element child : VaultFsConfig11.getChildElements(elem)) {
                if (child.getNodeName().equals("matches")) {
                    this.processFilter(ga.getMatchFilter(), child);
                    continue;
                }
                if (!child.getNodeName().equals("contains")) continue;
                this.processFilter(ga.getContentFilter(), child);
            }
        }
        this.getAggregators().add(aggregator);
    }

    private void processFilter(ItemFilterSet filterSet, Element elem) throws ConfigurationException {
        for (Element child : VaultFsConfig11.getChildElements(elem)) {
            Boolean isInclude = null;
            if (child.getNodeName().equals("include")) {
                isInclude = true;
            } else if (child.getNodeName().equals("exclude")) {
                isInclude = false;
            } else {
                log.warn("Unknown filter type in list: " + child.getNodeName());
            }
            if (isInclude == null) continue;
            try {
                NamedNodeMap attrs = child.getAttributes();
                ItemFilter filter = null;
                String clazz = child.getAttribute("class");
                if (clazz != null && clazz.length() > 0) {
                    filter = (ItemFilter)this.helper.create(child);
                } else if (attrs.getNamedItem("nodeType") != null) {
                    filter = new NodeTypeItemFilter();
                } else if (attrs.getNamedItem("isNode") != null) {
                    filter = new IsNodeFilter();
                } else if (attrs.getNamedItem("name") != null) {
                    filter = new NameItemFilter();
                } else if (attrs.getNamedItem("isMandatory") != null) {
                    filter = new IsMandatoryFilter();
                }
                if (filter == null) continue;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    if (!ConfigHelper.hasSetter(filter, attr.getName())) continue;
                    ConfigHelper.setField(filter, attr.getName(), attr.getValue());
                }
                if (isInclude.booleanValue()) {
                    filterSet.addInclude(filter);
                    continue;
                }
                filterSet.addExclude(filter);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                this.fail("Error while processing: " + e, child);
            }
        }
    }

    private void processHandler(Element elem) throws ConfigurationException {
        ArtifactHandler handler;
        String type = elem.getAttribute("type");
        if (type == null || type.equals("")) {
            type = "generic";
        }
        if ((handler = Registry.getInstance().createHandler(type)) == null) {
            this.fail("Handler of type " + type + " is not registered.", elem);
        }
        this.getHandlers().add(handler);
    }
}

