/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.filter;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.filter.DepthItemFilter;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class IsMandatoryFilter
extends DepthItemFilter {
    private boolean isMandatory = true;

    public IsMandatoryFilter() {
    }

    public IsMandatoryFilter(boolean isMandatory, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.isMandatory = isMandatory;
    }

    public IsMandatoryFilter(boolean isMandatory) {
        this(isMandatory, 0, Integer.MAX_VALUE);
    }

    public void setCondition(String node) {
        this.isMandatory = Boolean.valueOf(node);
    }

    public void setIsMandatory(String node) {
        this.isMandatory = Boolean.valueOf(node);
    }

    public boolean matches(Item item) throws RepositoryException {
        if (item.isNode()) {
            return ((Node)item).getDefinition().isMandatory() == this.isMandatory;
        }
        return ((Property)item).getDefinition().isMandatory() == this.isMandatory;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(true, "isMandatory: %b", this.isMandatory);
        ctx.outdent();
    }
}

