/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.util.PathUtil;
import com.day.jcr.vault.util.PlatformNameFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;

public abstract class AbstractArtifact
implements Artifact {
    private final String repoRelPath;
    private String platRelPath;
    private final String extension;
    private final ArtifactType type;
    private String contentType;

    protected AbstractArtifact(Artifact parent, String repoRelPath, String extension, ArtifactType type) {
        this.type = type;
        this.extension = extension;
        if (parent == null) {
            this.repoRelPath = repoRelPath;
            this.platRelPath = PlatformNameFormat.getPlatformPath(repoRelPath + extension);
        } else {
            this.repoRelPath = PathUtil.append(parent.getRelativePath(), repoRelPath);
            this.platRelPath = PathUtil.append(parent.getPlatformPath(), PlatformNameFormat.getPlatformPath(repoRelPath + extension));
        }
        if (this.platRelPath.equals(this.repoRelPath)) {
            this.platRelPath = null;
        }
    }

    protected AbstractArtifact(Artifact base, ArtifactType type) {
        this.type = type;
        this.extension = base.getExtension();
        this.repoRelPath = base.getRelativePath();
        this.platRelPath = base.getPlatformPath();
        this.contentType = base.getContentType();
    }

    public String getRelativePath() {
        return this.repoRelPath;
    }

    public String getPlatformPath() {
        return this.platRelPath == null ? this.repoRelPath : this.platRelPath;
    }

    public String getExtension() {
        return this.extension;
    }

    public ArtifactType getType() {
        return this.type;
    }

    public void spool(OutputStream out) throws IOException, RepositoryException {
        int read;
        InputStream in = this.getInputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
        in.close();
        out.close();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.type.toString());
        buf.append('(').append(this.repoRelPath).append(')');
        return buf.toString();
    }

    public String getContentType() {
        return this.contentType;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int hashCode() {
        return this.repoRelPath.hashCode() + 37 * this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Artifact) {
            Artifact a = (Artifact)obj;
            return this.getRelativePath().equals(a.getRelativePath()) && this.type == a.getType();
        }
        return false;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "Artifact");
        ctx.indent(isLast);
        ctx.printf(false, "rel path: %s", this.getRelativePath());
        ctx.printf(false, "plt path: %s", this.getPlatformPath());
        ctx.printf(false, "type: %s", new Object[]{this.getType()});
        ctx.printf(false, "serialization: %s", new Object[]{this.getSerializationType()});
        ctx.printf(false, "access type: %s", new Object[]{this.getPreferredAccess()});
        ctx.printf(false, "content type: %s", this.getContentType());
        ctx.printf(true, "content length: %d", this.getContentLength());
        ctx.outdent();
    }
}

