/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl;

import com.day.jcr.vault.fs.api.Aggregate;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.Dumpable;
import com.day.jcr.vault.fs.impl.AggregateImpl;
import com.day.jcr.vault.fs.impl.VaultFileImpl;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaultFileNode
implements Dumpable {
    private final AggregateImpl aggregate;
    private List<VaultFileImpl> files = new LinkedList<VaultFileImpl>();
    private Collection<VaultFileNode> children;
    private final VaultFileNode parent;

    public VaultFileNode(VaultFileNode parent, AggregateImpl node) throws RepositoryException {
        this.parent = parent;
        this.aggregate = node;
    }

    public String getName() {
        return this.aggregate.getRelPath();
    }

    public String getPath() {
        return this.aggregate.getPath();
    }

    public Collection<VaultFileNode> getChildren() throws RepositoryException {
        if (this.children == null) {
            this.children = new LinkedList<VaultFileNode>();
            List<? extends Aggregate> leaves = this.aggregate.getLeaves();
            if (leaves != null && !leaves.isEmpty()) {
                for (Aggregate aggregate : leaves) {
                    this.children.add(new VaultFileNode(this, (AggregateImpl)aggregate));
                }
            }
        }
        return this.children;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public void invalidate() {
        this.files.clear();
        this.aggregate.invalidate();
        this.children = null;
    }

    public VaultFileNode getParent() {
        return this.parent;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "VaultFileNode");
        ctx.indent(isLast);
        if (this.aggregate != null) {
            this.aggregate.dump(ctx, true);
        } else {
            ctx.println(true, "ArtifactsNode: (null)");
        }
        ctx.outdent();
    }

    protected List<VaultFileImpl> getFiles() {
        return this.files;
    }
}

