/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.AggregateManager;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.api.VaultFile;
import com.day.jcr.vault.fs.io.ExportInfo;
import com.day.jcr.vault.fs.spi.CNDWriter;
import com.day.jcr.vault.fs.spi.ProgressTracker;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractExporter.class);
    private ProgressTracker tracker;
    private boolean relativePaths;
    private String rootPath = "jcr_root";
    private Properties properties = new Properties();
    private boolean noMetaInf;
    protected ExportInfo exportInfo = new ExportInfo();

    public boolean isVerbose() {
        return this.tracker != null;
    }

    public void setVerbose(ProgressTrackerListener out) {
        if (out == null) {
            this.tracker = null;
        } else {
            if (this.tracker == null) {
                this.tracker = new ProgressTracker();
            }
            this.tracker.setListener(out);
        }
    }

    public boolean isRelativePaths() {
        return this.relativePaths;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setProperty(String name, Calendar value) {
        this.properties.put(name, ISO8601.format((Calendar)value));
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public boolean isNoMetaInf() {
        return this.noMetaInf;
    }

    public void setNoMetaInf(boolean noMetaInf) {
        this.noMetaInf = noMetaInf;
    }

    public ExportInfo getExportInfo() {
        return this.exportInfo;
    }

    public void setRelativePaths(boolean relativePaths) {
        this.relativePaths = relativePaths;
    }

    public void export(VaultFile parent) throws RepositoryException, IOException {
        this.export(parent, false);
    }

    public void export(VaultFile parent, boolean noClose) throws RepositoryException, IOException {
        this.exportInfo.getEntries().clear();
        this.open();
        AggregateManager mgr = parent.getFileSystem().getAggregateManager();
        mgr.startTracking(this.tracker == null ? null : this.tracker.getListener());
        if (!this.noMetaInf) {
            this.createDirectory("META-INF");
            this.createDirectory("META-INF/vault");
            this.track("A", "META-INF");
            this.track("A", "META-INF/vault");
            this.track("A", "META-INF/vault/config.xml");
            this.track("A", "META-INF/vault/filter.xml");
            this.track("A", "META-INF/vault/nodetypes.cnd");
            this.track("A", "META-INF/vault/properties.xml");
            this.writeFile(mgr.getConfig().getSource(), "META-INF/vault/config.xml");
            this.writeFile(mgr.getWorkspaceFilter().getSource(), "META-INF/vault/filter.xml");
        }
        this.export(parent, "");
        if (!this.noMetaInf) {
            this.writeFile(this.getNodeTypes(mgr.getSession(), mgr.getNodeTypes()), "META-INF/vault/nodetypes.cnd");
            this.setProperty("created", Calendar.getInstance());
            this.setProperty("createdBy", mgr.getUserId());
            this.setProperty("packageFormatVersion", String.valueOf(2));
            ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
            this.properties.storeToXML((OutputStream)tmpOut, "FileVault Package Properties", "utf-8");
            this.writeFile(new ByteArrayInputStream(tmpOut.toByteArray()), "META-INF/vault/properties.xml");
        }
        if (!noClose) {
            this.close();
        }
        mgr.stopTracking();
    }

    public void export(VaultFile parent, String relPath) throws RepositoryException, IOException {
        for (VaultFile vaultFile : parent.getChildren()) {
            String path = relPath + "/" + vaultFile.getName();
            if (vaultFile.isDirectory()) {
                this.createDirectory(vaultFile, path);
                this.export(vaultFile, path);
                continue;
            }
            this.writeFile(vaultFile, path);
        }
    }

    protected void track(String action, String path) {
        if ("E".equals(action)) {
            log.error("{} {}", (Object)action, (Object)path);
        } else {
            log.info("{} {}", (Object)action, (Object)path);
        }
        if (this.tracker != null) {
            this.tracker.track(action, path);
        }
    }

    protected void track(Exception e, String path) {
        log.error("E {} ({})", (Object)path, (Object)e.toString());
        if (this.tracker != null) {
            this.tracker.track(e, path);
        }
    }

    protected String getPlatformFilePath(VaultFile file, String relPath) {
        StringBuffer buf = new StringBuffer(this.rootPath);
        if (this.isRelativePaths()) {
            if (buf.length() > 0) {
                buf.append("/");
            }
            buf.append(relPath);
        } else {
            buf.append(file.getPath());
        }
        return buf.toString();
    }

    private InputStream getNodeTypes(Session s, Collection<String> nodeTypes) throws IOException, RepositoryException {
        NodeTypeManager ntMgr = s.getWorkspace().getNodeTypeManager();
        HashSet<String> written = new HashSet<String>();
        written.addAll(ServiceProviderFactory.getProvider().getBuiltInNodeTypeNames());
        StringWriter out = new StringWriter();
        CNDWriter w = ServiceProviderFactory.getProvider().getCNDWriter((Writer)out, s, true);
        for (String nt : nodeTypes) {
            this.writeNodeType(ntMgr.getNodeType(nt), w, written);
        }
        w.close();
        return new ByteArrayInputStream(out.getBuffer().toString().getBytes("utf-8"));
    }

    private void writeNodeType(NodeType nt, CNDWriter w, Set<String> written) throws IOException, RepositoryException {
        if (nt != null && !written.contains(nt.getName())) {
            written.add(nt.getName());
            w.write(nt);
            for (NodeType nodeType : nt.getSupertypes()) {
                this.writeNodeType(nodeType, w, written);
            }
            for (NodeType nodeType : nt.getChildNodeDefinitions()) {
                this.writeNodeType(nodeType.getDefaultPrimaryType(), w, written);
                if (nodeType.getRequiredPrimaryTypes() == null) continue;
                for (NodeType r : nodeType.getRequiredPrimaryTypes()) {
                    this.writeNodeType(r, w, written);
                }
            }
        }
    }

    public abstract void open() throws IOException, RepositoryException;

    public abstract void close() throws IOException, RepositoryException;

    public abstract void createDirectory(String var1) throws IOException;

    public abstract void createDirectory(VaultFile var1, String var2) throws RepositoryException, IOException;

    public abstract void writeFile(InputStream var1, String var2) throws IOException;

    public abstract void writeFile(VaultFile var1, String var2) throws RepositoryException, IOException;
}

