/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.AbstractArchive;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.util.Text;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZipFileArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(ZipFileArchive.class);
    private ZipFile zip;
    private JarEntry root;

    public ZipFileArchive(ZipFile zip) {
        this.zip = zip;
    }

    public void open(boolean strict) throws IOException {
        this.root = new JarEntry("", true);
        Enumeration<? extends ZipEntry> e = this.zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String path = entry.getName();
            String[] names = Text.explode(path, 47);
            if (names.length <= 0) continue;
            JarEntry je = this.root;
            for (int i = 0; i < names.length; ++i) {
                je = i == names.length - 1 ? je.add(names[i], entry.isDirectory()) : je.add(names[i], true);
            }
            je.zipEntryName = entry.getName();
            log.debug("scanning jar: {}", (Object)je.zipEntryName);
        }
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        JarEntry e = (JarEntry)entry;
        if (e == null || e.zipEntryName == null) {
            return null;
        }
        ZipEntry ze = this.zip.getEntry(e.zipEntryName);
        if (ze == null) {
            throw new IOException("ZipEntry could not be found: " + e.zipEntryName);
        }
        return this.zip.getInputStream(ze);
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        JarEntry e = (JarEntry)entry;
        if (e == null || e.zipEntryName == null) {
            return null;
        }
        final ZipEntry ze = this.zip.getEntry(e.zipEntryName);
        if (ze == null) {
            throw new IOException("ZipEntry could not be found: " + e.zipEntryName);
        }
        return new VaultInputSource(){
            {
                this.setSystemId(ze.getName());
            }

            public InputStream getByteStream() {
                try {
                    return ZipFileArchive.this.zip.getInputStream(ze);
                }
                catch (IOException e1) {
                    return null;
                }
            }

            public long getContentLength() {
                return ze.getSize();
            }

            public long getLastModified() {
                return ze.getTime();
            }
        };
    }

    public void close() {
        try {
            if (this.zip != null) {
                this.zip.close();
                this.zip = null;
            }
        }
        catch (IOException e) {
            log.warn("Error during close.", (Throwable)e);
        }
    }

    public Archive.Entry getRoot() throws IOException {
        return this.root;
    }

    public MetaInf getMetaInf() {
        throw new IllegalStateException("getMetaInf() should not be called directly.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarEntry
    implements Archive.Entry {
        public final String name;
        private String zipEntryName;
        public final boolean isDirectory;
        public Map<String, JarEntry> children;

        public JarEntry(String name, boolean directory) {
            this.name = name;
            this.isDirectory = directory;
        }

        public JarEntry add(String name, boolean isDirectory) {
            JarEntry ret;
            if (this.children != null && (ret = this.children.get(name)) != null) {
                return ret;
            }
            return this.add(new JarEntry(name, isDirectory));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        public JarEntry add(JarEntry e) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, JarEntry>();
            }
            this.children.put(e.getName(), e);
            return e;
        }

        @Override
        public Collection<? extends Archive.Entry> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children.values();
        }

        @Override
        public Archive.Entry getChild(String name) {
            return this.children == null ? null : this.children.get(name);
        }
    }
}

