/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "com.day.jcr.vault:maven-vault-plugin:0.0.10", 0);
        this.append(sb, "", 0);
        this.append(sb, "Adobe File Vault Maven Plugin", 0);
        this.append(sb, "Maven Plugin supporting various File Vault tasks", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "build".equals(this.goal)) {
            this.append(sb, "vault:build", 0);
            this.append(sb, "Builds a content package defined on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name of the package to remove on the target system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "vault:help", 0);
            this.append(sb, "Display help information on maven-vault-plugin.\nCall\n\u00a0\u00a0mvn\u00a0vault:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install".equals(this.goal)) {
            this.append(sb, "vault:install", 0);
            this.append(sb, "Install a Content Package on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifact", 2);
                this.append(sb, "A string of the form groupId:artifactId:version[:packaging].", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactId", 2);
                this.append(sb, "The artifactId of the artifact to install", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupId", 2);
                this.append(sb, "The groupId of the artifact to install", 3);
                this.append(sb, "", 0);
                this.append(sb, "install (Default: true)", 2);
                this.append(sb, "Whether to install (unpack) the uploaded package automatically or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "name (Default: ${project.artifactId})", 2);
                this.append(sb, "The name of the content package", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageFile", 2);
                this.append(sb, "The name of the content package file to install on the target system. If not set, the primary artifact of the project is considered the content package to be installed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packaging (Default: zip)", 2);
                this.append(sb, "The packaging of the artifact to install", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryId (Default: temp)", 2);
                this.append(sb, "The id of the repository from which we'll download the artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryUrl", 2);
                this.append(sb, "The url of the repository from which we'll download the artifact", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the artifact to install", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "ls".equals(this.goal)) {
            this.append(sb, "vault:ls", 0);
            this.append(sb, "Lists packages installed on remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "package".equals(this.goal)) {
            this.append(sb, "vault:package", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See the documentation for Maven Archiver.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The directory containing the content to be packaged up into the content package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dependencies", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "embeddeds", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "embeddedTarget", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Defines the content of the filter.xml file", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated package ZIP file without the '.zip' file extension.", 3);
                this.append(sb, "", 0);
                this.append(sb, "group (Default: ${project.groupId})", 2);
                this.append(sb, "The groupId used for the generated content package. This will be part of the target installation path of the content package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "hotfix", 2);
                this.append(sb, "Defines information about the generated hotfix. Specifically the hotfix id must be defined for this project to be considered a hotfix.", 3);
                this.append(sb, "", 0);
                this.append(sb, "name (Default: ${project.artifactId})", 2);
                this.append(sb, "The name of the content package", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Specifies additional properties to be set in the properties.xml file. These properties cannot overwrite the following predefined properties: \ngroup\nUse group parameter to set\nname\nUse name parameter to set\nversion\nUse version parameter to set\ndescription\nSet from the project description\ngroupId\ngroupId of the Maven project descriptor\nartifactId\nartifactId of the Maven project descriptor\ndependencies\nUse dependencies parameter to set\ncreatedBy\nThe value of the user.name system property\ncreated\nThe current system time\nrequiresRoot\nUse requiresRoot parameter to set\npackagePath\nAutomatically generated from the group and package name", 3);
                this.append(sb, "", 0);
                this.append(sb, "requiresRoot (Default: false)", 2);
                this.append(sb, "Defines whether the package requires the root. This will become the requiresRoot property of the properties.xml file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "subPackages", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: ${project.version})", 2);
                this.append(sb, "The version of the content package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workDirectory (Default: ${project.build.directory}/vault-work)", 2);
                this.append(sb, "The directory containing the content to be packaged up into the content package.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rm".equals(this.goal)) {
            this.append(sb, "vault:rm", 0);
            this.append(sb, "Removes a content package installed on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name of the package to remove on the target system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "share".equals(this.goal)) {
            this.append(sb, "vault:share", 0);
            this.append(sb, "Share a Content Package on Adobe Package Share", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "name (Default: ${project.artifactId})", 2);
                this.append(sb, "The name of the content package", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageFile", 2);
                this.append(sb, "The name of the content package file to install on the target system. If not set, the primary artifact of the project is considered the content package to be installed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to authenticate against Adobe Package Share.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverURL", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 30)", 2);
                this.append(sb, "The connection timeout to set when communicating with Adobe Package Share. Default value is 30 seconds. Value is specified in seconds.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId", 2);
                this.append(sb, "The user name to authenticate as against Adobe Package Share.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "uninstall".equals(this.goal)) {
            this.append(sb, "vault:uninstall", 0);
            this.append(sb, "Uninstalls a content package installed on a remote CRX or Communique 5 system.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name of the package to uninstall on the target system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: admin)", 2);
                this.append(sb, "The password to authenticate against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The server id with which to get the username and password from the user's settings file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetURL (Default: http://localhost:4502/crx/packmgr/service.jsp)", 2);
                this.append(sb, "The URL to the HTTP service API of the CRX package manager. See HTTP Service Interface for details on this interface.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 5)", 2);
                this.append(sb, "The connection timeout to set when communicating with the package manager service. Default value is 5 seconds. Value is specified in seconds.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProxy (Default: true)", 2);
                this.append(sb, "Setting this to false disables considering the use of any of the active proxies configured in the Maven Settings. By default the first active proxy configuration in the Maven Settings is used to proxy any request to the package manager.", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: admin)", 2);
                this.append(sb, "The user name to authenticate as against the remote CRX system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose logging when set to true.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

