/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.pack;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;

public class HotfixInfo {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("dd-MMM-yyyy");
    private static final String PREFIX_HOTFIX = "hotfix";
    private static final String PREFIX_FEATURE_PACK = "featurepack";
    private String id;
    private String productName = "Communique";
    private String productVersion = "5.2.1";
    private boolean featurePack = false;
    private final TreeSet bugs = new TreeSet();
    private final TreeSet includedFiles = new TreeSet();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isHotfixOrFeaturePack() {
        return this.id != null;
    }

    public void setFeaturePack(boolean featurePack) {
        this.featurePack = featurePack;
    }

    public boolean isFeaturePack() {
        return this.featurePack;
    }

    public String getFilePrefix() {
        return this.isFeaturePack() ? PREFIX_FEATURE_PACK : PREFIX_HOTFIX;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void addBug(String bug) {
        this.bugs.add(bug);
    }

    public TreeSet getBugs() {
        return this.bugs;
    }

    public void addIncludedFile(String includedFile) {
        includedFile = StringUtils.chompLast((String)includedFile, (String)"/.content.xml");
        includedFile = StringUtils.chompLast((String)includedFile, (String)".xml");
        this.includedFiles.add(includedFile);
    }

    public TreeSet getIncludedFiles() {
        return this.includedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateReadme(File readmeFile) throws IOException {
        FileWriter w;
        InputStreamReader r;
        InputStream ins;
        block4: {
            String templateFile;
            block3: {
                if (!this.isHotfixOrFeaturePack()) {
                    return;
                }
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("date", FORMAT.format(new Date()));
                variables.put("id", this.getId());
                variables.put("product.name", this.getProductName());
                variables.put("product.version", this.getProductVersion());
                variables.put("bugs", this.toList(this.getBugs()));
                variables.put("files", this.toList(this.getIncludedFiles()));
                templateFile = "/" + this.getFilePrefix() + ".README.template";
                ins = this.getClass().getResourceAsStream(templateFile);
                if (ins == null) break block3;
                r = null;
                w = null;
                try {
                    r = new InputStreamReader(ins);
                    r = new InterpolationFilterReader((Reader)r, variables);
                    w = new FileWriter(readmeFile);
                    IOUtil.copy((Reader)r, (Writer)w);
                }
                catch (Throwable throwable) {
                    IOUtil.close(r);
                    IOUtil.close(w);
                    IOUtil.close((InputStream)ins);
                    throw throwable;
                }
                break block4;
            }
            throw new IOException("Plugin is corrupt; template file " + templateFile + " not found");
        }
        IOUtil.close((Reader)r);
        IOUtil.close((Writer)w);
        IOUtil.close((InputStream)ins);
    }

    private String toList(Collection entries) {
        if (entries.isEmpty()) {
            return "    -\r\n";
        }
        StringBuilder entryList = new StringBuilder();
        for (String entry : entries) {
            entryList.append("    ").append(entry).append("\r\n");
        }
        return entryList.toString();
    }
}

