/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.pack;

import com.day.jcr.vault.maven.pack.Dependency;
import com.day.jcr.vault.maven.pack.Embedded;
import com.day.jcr.vault.maven.pack.Filter;
import com.day.jcr.vault.maven.pack.HotfixInfo;
import com.day.jcr.vault.maven.pack.SubPackage;
import com.day.jcr.vault.maven.pack.WorkspaceFilter;
import com.day.jcr.vault.packaging.PackageId;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.impl.StaticLoggerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaultMojo
extends AbstractMojo {
    private static final String JCR_ROOT = "jcr_root/";
    private static final String VAULT_DIR = "META-INF/vault";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String PACKAGE_TYPE = "zip";
    private static final String PACKAGE_EXT = ".zip";
    private static final String README_CLASSIFIER = "readme";
    private static final String README_TYPE = "txt";
    private static final String README_EXT = "-readme.txt";
    private MavenProject project;
    private ArtifactHandlerManager artifactHandlerManager;
    private File classesDirectory;
    private String finalName;
    private File outputDirectory;
    private File workDirectory;
    private MavenArchiveConfiguration archive;
    private String prefix;
    private String group;
    private String name;
    private String version;
    private final HotfixInfo hotfix = new HotfixInfo();
    private boolean requiresRoot;
    private final WorkspaceFilter filters = new WorkspaceFilter();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<SubPackage> subPackages = new ArrayList<SubPackage>();
    private final List<Embedded> embeddeds = new ArrayList<Embedded>();
    private final Map properties = new HashMap();
    private String embeddedTarget;

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addEmbedded(Embedded embedded) {
        this.embeddeds.add(embedded);
    }

    public void addPackage(SubPackage jcrPackage) {
        this.subPackages.add(jcrPackage);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void setEmbeddedTarget(String embeddedTarget) {
        this.embeddedTarget = embeddedTarget.endsWith("/") ? embeddedTarget : embeddedTarget + "/";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.prefix == null) {
            this.prefix = "";
        } else if (!this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
        File vaultDir = new File(this.workDirectory, VAULT_DIR);
        File definitionDir = new File(vaultDir, "definition");
        File finalFile = new File(this.outputDirectory, this.finalName + PACKAGE_EXT);
        try {
            vaultDir.mkdirs();
            definitionDir.mkdirs();
            Map<String, File> embeddedFiles = this.copyEmbeddeds();
            embeddedFiles.putAll(this.copySubPackages());
            this.writeProperties(new File(vaultDir, "properties.xml"));
            File filterFile = new File(vaultDir, "filter.xml");
            if (filterFile.exists()) {
                filterFile = new File(vaultDir, "filter-plugin-generated.xml");
            } else if (this.filters.isEmpty() && this.prefix.length() > 0) {
                this.addWorkspaceFilter(this.prefix);
            }
            if (!this.filters.isEmpty()) {
                this.filters.write(filterFile);
            }
            this.copyFile("/vault/config.xml", new File(vaultDir, "config.xml"));
            this.copyFile("/vault/settings.xml", new File(vaultDir, "settings.xml"));
            this.copyFile("/vault/content.xml", new File(definitionDir, ".content.xml"));
            if (this.hotfix.isHotfixOrFeaturePack()) {
                File readmeFile = new File(this.workDirectory, "README");
                File finalReadmeFile = new File(this.outputDirectory, this.finalName + README_EXT);
                this.getLog().info((CharSequence)("Creating readme: " + finalReadmeFile));
                this.copyFile("/vault/" + this.hotfix.getFilePrefix() + ".thumbnail.png", new File(definitionDir, "thumbnail.png"));
                if (this.classesDirectory.exists()) {
                    List names = FileUtils.getFileNames((File)this.classesDirectory, null, null, (boolean)false);
                    for (Object name : names) {
                        this.hotfix.addIncludedFile(this.makeAbsolutePath(name.toString()));
                    }
                }
                if (!readmeFile.exists()) {
                    this.hotfix.generateReadme(readmeFile);
                }
                FileUtils.copyFile((File)readmeFile, (File)finalReadmeFile);
                AttachedArtifact readmeArtifact = new AttachedArtifact(this.project.getArtifact(), README_TYPE, README_CLASSIFIER, this.artifactHandlerManager.getArtifactHandler(README_TYPE));
                readmeArtifact.setFile(finalReadmeFile);
                this.project.addAttachedArtifact((Artifact)readmeArtifact);
            } else {
                this.copyFile("/vault/package.thumbnail.png", new File(definitionDir, "thumbnail.png"));
            }
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.addDirectory(this.workDirectory);
            if (this.classesDirectory.exists()) {
                jarArchiver.addDirectory(this.classesDirectory, FileUtils.normalize((String)(JCR_ROOT + this.prefix)));
            }
            for (Map.Entry<String, File> entry : embeddedFiles.entrySet()) {
                jarArchiver.addFile(entry.getValue(), entry.getKey());
            }
            jarArchiver.setIncludeEmptyDirs(true);
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver(jarArchiver);
            mavenArchiver.setOutputFile(finalFile);
            mavenArchiver.createArchive(this.project, this.getMavenArchiveConfiguration());
            Artifact projectArtifact = this.project.getArtifact();
            projectArtifact.setFile(finalFile);
            projectArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(PACKAGE_TYPE));
        }
        catch (Exception drre) {
            throw new MojoExecutionException(drre.toString(), drre);
        }
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration() {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setManifest(new ManifestConfiguration());
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
            this.archive.getManifest().setAddDefaultSpecificationEntries(true);
            this.archive.getManifest().setAddDefaultImplementationEntries(true);
        }
        return this.archive;
    }

    private void writeProperties(File propsFile) throws IOException {
        String description = this.project.getDescription();
        if (description == null && (description = this.project.getName()) == null) {
            description = this.project.getArtifactId();
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        props.put("group", this.group);
        props.put("name", this.name);
        props.put("version", this.version);
        props.put("description", description);
        props.put("groupId", this.project.getGroupId());
        props.put("artifactId", this.project.getArtifactId());
        if (!this.dependencies.isEmpty()) {
            props.put("dependencies", Dependency.toString(this.dependencies));
        }
        if (!props.containsKey("createdBy")) {
            props.put("createdBy", System.getProperty("user.name"));
        }
        props.put("created", DATE_FORMAT.format(new Date()));
        props.put("requiresRoot", String.valueOf(this.requiresRoot));
        props.put("path", "/etc/packages/" + this.group + "/" + this.name + PACKAGE_EXT);
        FileOutputStream fos = new FileOutputStream(propsFile);
        props.storeToXML(fos, this.project.getName());
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String source, File target) throws IOException {
        if (target.exists()) {
            return;
        }
        target.getParentFile().mkdirs();
        InputStream ins = ((Object)((Object)this)).getClass().getResourceAsStream(source);
        if (ins != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(target);
                IOUtil.copy((InputStream)ins, (OutputStream)out);
            }
            finally {
                IOUtil.close((InputStream)ins);
                IOUtil.close((OutputStream)out);
            }
        }
    }

    private Map<String, File> copyEmbeddeds() throws IOException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (Embedded emb : this.embeddeds) {
            String targetPath;
            List<Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            if (emb.getDestFileName() != null && artifacts.size() > 1) {
                this.getLog().warn((CharSequence)("destFileName defined but several artifacts match for " + emb));
            }
            if ((targetPath = emb.getTarget()) == null && (targetPath = this.embeddedTarget) == null) {
                String loc = this.prefix.length() == 0 ? "/apps/" : this.prefix;
                targetPath = loc + "bundles/install/";
                this.getLog().info((CharSequence)("No target path set on " + emb + "; assuming default " + targetPath));
            }
            targetPath = this.makeAbsolutePath(targetPath);
            targetPath = JCR_ROOT + targetPath;
            targetPath = FileUtils.normalize((String)targetPath);
            this.getLog().info((CharSequence)("Embedding --- " + emb + " ---"));
            Iterator<Artifact> i$ = artifacts.iterator();
            while (i$.hasNext()) {
                Artifact artifact1;
                Artifact artifact = artifact1 = i$.next();
                File source = artifact.getFile();
                String destFileName = emb.getDestFileName();
                if (destFileName == null) {
                    destFileName = source.getName();
                }
                String targetPathName = targetPath + destFileName;
                String targetNodePathName = targetPathName.substring(JCR_ROOT.length() - 1);
                fileMap.put(targetPathName, source);
                this.getLog().info((CharSequence)("Embedding " + artifact.getId() + " -> " + targetPathName));
                if (this.hotfix.isHotfixOrFeaturePack()) {
                    this.hotfix.addIncludedFile(targetNodePathName);
                }
                if (!emb.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, File> copySubPackages() throws IOException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (SubPackage pack : this.subPackages) {
            List<Artifact> artifacts = pack.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                this.getLog().warn((CharSequence)("No matching artifacts for " + pack));
                continue;
            }
            this.getLog().info((CharSequence)("Embedding --- " + pack + " ---"));
            Iterator<Artifact> i$ = artifacts.iterator();
            while (i$.hasNext()) {
                Artifact artifact1;
                Artifact artifact = artifact1 = i$.next();
                File source = artifact.getFile();
                ZipFile zip = null;
                InputStream in = null;
                Properties props = new Properties();
                try {
                    zip = new ZipFile(source, 1);
                    ZipEntry e = zip.getEntry("META-INF/vault/properties.xml");
                    if (e == null) {
                        this.getLog().error((CharSequence)"Package does not contain properties.xml");
                        throw new IOException("properties.xml missing");
                    }
                    in = zip.getInputStream(e);
                    props.loadFromXML(in);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    if (zip != null) {
                        zip.close();
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (zip != null) {
                    zip.close();
                }
                PackageId pid = new PackageId(props.getProperty("group"), props.getProperty("name"), props.getProperty("version"));
                String targetNodePathName = pid.getInstallationPath() + PACKAGE_EXT;
                String targetPathName = "jcr_root" + targetNodePathName;
                fileMap.put(targetPathName, source);
                this.getLog().info((CharSequence)("Embedding " + artifact.getId() + " -> " + targetPathName));
                if (this.hotfix.isHotfixOrFeaturePack()) {
                    this.hotfix.addIncludedFile(targetNodePathName);
                }
                if (!pack.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    private void addWorkspaceFilter(String filterRoot) {
        this.filters.add(new Filter(filterRoot));
    }

    private String makeAbsolutePath(String relPath) {
        String absPath;
        if (!relPath.startsWith("/")) {
            absPath = (this.prefix.length() == 0 ? "/" : this.prefix) + relPath;
            this.getLog().info((CharSequence)("Relative path resolved to " + absPath));
        } else {
            absPath = relPath;
        }
        return absPath;
    }
}

