/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.pack.impl;

import com.day.jcr.vault.fs.api.FilterSet;
import com.day.jcr.vault.maven.pack.impl.StringFilter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFilterSet
extends FilterSet<StringFilter> {
    public void addEntry(String pattern) {
        if (pattern.startsWith("~")) {
            this.addExclude(new StringFilter(pattern.substring(1)));
        } else {
            this.addInclude(new StringFilter(pattern));
        }
    }

    public void addEntries(String patterns) {
        for (String name : patterns.split(",")) {
            this.addEntry(name.trim());
        }
    }

    public boolean contains(String path) {
        List entries = this.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        boolean result = !entries.get(0).isInclude();
        for (FilterSet.Entry entry : entries) {
            if (!((StringFilter)entry.getFilter()).matches(path)) continue;
            result = entry.isInclude();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String delim = "";
        for (FilterSet.Entry entry : this.getEntries()) {
            builder.append(delim);
            if (!entry.isInclude()) {
                builder.append("~");
            }
            builder.append(entry.getFilter());
            delim = ",";
        }
        return builder.toString();
    }
}

