/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.share;

import com.day.jcr.vault.maven.share.ClientContextImpl;
import com.day.packageshare.client.PackageShareSession;
import com.day.packageshare.client.impl.PackageShareImpl;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

abstract class AbstractPackageShareMojo
extends AbstractMojo {
    private Settings settings;
    private String userId;
    private String password;
    private String serverId;
    private boolean verbose;
    private int timeout;
    private boolean useProxy;
    private String serverURL;
    private SecDispatcher securityDispatcher;

    AbstractPackageShareMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
    }

    public String getUserId() {
        if (this.serverId != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                throw new IllegalArgumentException(String.format("Server ID %s does not exist in settings.xml.", this.serverId));
            }
            return server.getUsername();
        }
        if (this.userId == null) {
            throw new IllegalArgumentException("Either serverId or userId needs to be specified.");
        }
        return this.userId;
    }

    public String getPassword() throws SecDispatcherException {
        if (this.serverId != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                throw new IllegalArgumentException(String.format("Server ID %s does not exist in settings.xml.", this.serverId));
            }
            return this.securityDispatcher.decrypt(server.getPassword());
        }
        if (this.password == null) {
            throw new IllegalArgumentException("Either serverId or password needs to be specified.");
        }
        return this.password;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getTimoutMs() {
        return 1000 * this.timeout;
    }

    public PackageShareSession login() throws MojoExecutionException {
        Properties props = new Properties();
        if (this.serverURL != null) {
            props.put("url", this.serverURL);
        }
        PackageShareImpl ps = new PackageShareImpl(props);
        this.setupProxy(ps.getHttpClient());
        ps.getHttpClient().getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimoutMs());
        ClientContextImpl ctx = new ClientContextImpl();
        PackageShareSession s = null;
        try {
            s = ps.login(ctx, this.getUserId(), this.getPassword());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error during login.", (Throwable)e);
        }
        if (s == null) {
            throw new MojoExecutionException("Unable to login to package share server.");
        }
        return s;
    }

    private void setupProxy(HttpClient client) {
        List proxies = this.settings.getProxies();
        if (this.useProxy && proxies != null && !proxies.isEmpty()) {
            this.getLog().debug((CharSequence)("Considering " + proxies.size() + " proxies"));
            for (Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                this.getLog().debug((CharSequence)("Using proxy " + proxy.getHost() + ":" + proxy.getPort()));
                client.getHostConfiguration().setProxy(proxy.getHost(), proxy.getPort());
                if (proxy.getUsername() != null) {
                    UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                    client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)proxyCredentials);
                }
                break;
            }
        } else {
            this.getLog().debug((CharSequence)("Proxying disabled (useProxy=" + this.useProxy + ") or no proxies configured"));
        }
    }
}

