/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.share;

import com.day.jcr.vault.maven.share.AbstractPackageShareMojo;
import com.day.jcr.vault.maven.share.ProxyTrackerImpl;
import com.day.packageshare.client.JSONResponse;
import com.day.packageshare.client.PackageShareSession;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class PackageShareMojo
extends AbstractPackageShareMojo {
    private MavenProject project;
    private File packageFile;
    private String name;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.packageFile == null) {
            this.packageFile = this.project.getArtifact().getFile();
            if (this.packageFile == null) {
                throw new MojoExecutionException("Missing artifact to install.");
            }
        }
        if (!this.packageFile.canRead()) {
            throw new MojoExecutionException("Cannot access jar file " + this.packageFile);
        }
        this.uploadPackage();
    }

    private void uploadPackage() throws MojoExecutionException {
        block6: {
            PackageShareSession s = this.login();
            try {
                ProxyTrackerImpl tracker = new ProxyTrackerImpl(this.getLog());
                JSONResponse resp = s.uploadPackage(this.packageFile, this.packageFile.getName(), tracker, null);
                if (resp != null) {
                    this.getLog().info((CharSequence)resp.getMessage());
                    break block6;
                }
                this.getLog().error((CharSequence)"No valid response.");
                throw new MojoExecutionException("Error sharing package.");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error sharing package", (Exception)e);
            }
            finally {
                s.logout();
            }
        }
    }
}

