/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.packaging.impl;

import com.day.jcr.vault.fs.api.VaultFileSystem;
import com.day.jcr.vault.fs.io.Importer;
import com.day.jcr.vault.packaging.ImportOptions;
import com.day.jcr.vault.packaging.InstallContext;
import com.day.jcr.vault.packaging.VaultPackage;
import com.day.jcr.vault.packaging.impl.InstallHookProcessor;
import javax.jcr.Session;

public class InstallContextImpl
implements InstallContext {
    private final Session session;
    private final VaultPackage pack;
    private InstallContext.Phase phase = InstallContext.Phase.PREPARE;
    private final VaultFileSystem fs;
    private final Importer importer;
    private final InstallHookProcessor hooks;

    public InstallContextImpl(VaultFileSystem vltfs, VaultPackage pack, Importer importer, InstallHookProcessor hooks) {
        this.session = vltfs.getAggregateManager().getSession();
        this.fs = vltfs;
        this.pack = pack;
        this.importer = importer;
        this.hooks = hooks;
    }

    public Session getSession() {
        return this.session;
    }

    public VaultPackage getPackage() {
        return this.pack;
    }

    public ImportOptions getImportOptions() {
        return new ImportOptions(this.importer.getOptions());
    }

    public com.day.jcr.vault.fs.io.ImportOptions getOptions() {
        return this.importer.getOptions();
    }

    public InstallContext.Phase getPhase() {
        return this.phase;
    }

    protected void setPhase(InstallContext.Phase phase) {
        this.phase = phase;
    }

    protected VaultFileSystem getVaultFileSystem() {
        return this.fs;
    }

    protected Importer getImporter() {
        return this.importer;
    }

    protected InstallHookProcessor getHooks() {
        return this.hooks;
    }
}

