/*
 * Decompiled with CFR 0.152.
 */
package com.day.packageshare.client;

import com.day.packageshare.client.JSONResponse;
import com.day.packageshare.client.impl.proxy.AttributeList;
import com.day.packageshare.client.impl.proxy.DocumentHandler;
import com.day.packageshare.client.impl.proxy.HtmlParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HtmlStatusResponseParser {
    private static final Set<String> TAGS;

    public static JSONResponse parse(String data) throws IOException {
        Handler h = new Handler();
        HtmlParser p = new HtmlParser();
        p.setDocumentHandler(h);
        p.setTagInclusionSet(TAGS);
        p.update(data.toCharArray(), 0, data.length());
        p.finished();
        return h.resp;
    }

    static {
        HashSet<String> tags = new HashSet<String>();
        tags.add("A");
        tags.add("DIV");
        TAGS = Collections.unmodifiableSet(tags);
    }

    private static class Handler
    implements DocumentHandler {
        private String id = null;
        private int statusCode = 0;
        private String statusMessage = "";
        private final JSONResponse resp = new JSONResponse();

        private Handler() {
        }

        public void characters(char[] ch, int off, int len) throws IOException {
            if (this.id == null) {
                return;
            }
            String str = new String(ch, off, len);
            if (this.id.equals("Status")) {
                this.statusCode = Integer.parseInt(str);
                this.resp.setStatus(this.statusCode);
                this.resp.setSuccess(this.statusCode == 200);
            } else if (this.id.equals("Message")) {
                this.statusMessage = str;
                this.resp.setMessage(this.statusMessage);
            } else if (this.id.equals("Path")) {
                this.resp.setPath(str);
            } else if (!this.id.equals("Referer")) {
                if (this.id.equals("Location")) {
                    this.resp.setLocation(str);
                } else if (this.id.equals("ParentLocation")) {
                    // empty if block
                }
            }
            this.id = null;
        }

        public void onStartElement(String name, AttributeList attList, char[] ch, int off, int len, boolean endSlash) throws IOException {
            this.id = attList.getValue("id");
        }

        public void onEndElement(String name, char[] ch, int off, int len) throws IOException {
        }

        public void onStart() throws IOException {
        }

        public void onEnd() throws IOException {
        }
    }
}

