/*
 * Decompiled with CFR 0.152.
 */
package com.day.packageshare.client.impl;

import com.day.commons.org.json.JSONException;
import com.day.commons.org.json.JSONObject;
import com.day.packageshare.client.ClientContext;
import com.day.packageshare.client.PackageShare;
import com.day.packageshare.client.PackageShareSession;
import com.day.packageshare.client.Proxy;
import com.day.packageshare.client.impl.EasySSLProtocolSocketFactory;
import com.day.packageshare.client.impl.PackageShareSessionImpl;
import com.day.packageshare.client.impl.proxy.ProxyImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageShareImpl
implements PackageShare {
    public static final int CLIENT_VERSION_2 = 2;
    public static final int CLIENT_VERSION = 2;
    private static final Logger log = LoggerFactory.getLogger(PackageShareImpl.class);
    private static final String DEFAULT_SERVER_URL = "https://dev.day.com";
    private static final String SHARE_LOGIN_PATH = "/content/packageshare.login.html?sling:authRequestLogin=1";
    public static final String SERVER_URL = "url";
    public static final String RELAXED_SSL = "relaxedSSL";
    public static final String EXPIRED_SSL = "expiredSSL";
    private HttpClient httpClient = null;
    private MultiThreadedHttpConnectionManager connectionManager;
    private String defaultSpoolPath = null;
    private String defaultRewritePath = null;
    private final Map<String, PackageShareSession> pool = new HashMap<String, PackageShareSession>();

    public PackageShareImpl(Properties props) {
        String serverUrl = props.getProperty(SERVER_URL);
        if (serverUrl == null || serverUrl.length() == 0) {
            serverUrl = DEFAULT_SERVER_URL;
        }
        boolean relaxedSSL = !props.contains(RELAXED_SSL) || "true".equals(props.getProperty(RELAXED_SSL));
        boolean expiredSSL = !props.contains(EXPIRED_SSL) || "true".equals(props.getProperty(EXPIRED_SSL));
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.connectionManager.getParams().setConnectionTimeout(30000);
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        try {
            URI uri = new URI(serverUrl, false);
            log.info("Initializing Package Share Host {}", (Object)uri);
            if (uri.getScheme().equals("https")) {
                log.info("* Accept self-certified SSL certificates: {}", (Object)relaxedSSL);
                log.info("* Accept expired SSL certificates: {}", (Object)expiredSSL);
                Protocol myhttps = Protocol.getProtocol((String)"https");
                if (relaxedSSL) {
                    myhttps = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(expiredSSL), 443);
                }
                this.httpClient.getHostConfiguration().setHost(uri.getHost(), uri.getPort(), myhttps);
            } else {
                this.httpClient.getHostConfiguration().setHost(uri);
            }
        }
        catch (URIException e) {
            log.error("Unable to initialize Package Share service", (Throwable)e);
        }
    }

    public void close() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    private String getIdString(ClientContext ctx) {
        try {
            StringBuffer b = new StringBuffer();
            b.append("i=").append(URIUtil.encodeWithinQuery((String)ctx.getLicenseId()));
            b.append(",p=").append(URIUtil.encodeWithinQuery((String)ctx.getProductName()));
            b.append(",v=").append(URIUtil.encodeWithinQuery((String)ctx.getProductVersion()));
            b.append(",cv=").append(2);
            return b.toString();
        }
        catch (URIException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageShareSession getSession(String id) {
        Map<String, PackageShareSession> map = this.pool;
        synchronized (map) {
            return this.pool.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageShareSession getSession(ClientContext ctx) {
        PackageShareSession s;
        String id = ctx.getSessionId();
        PackageShareSession packageShareSession = s = id == null ? null : this.getSession(id);
        if (s == null) {
            s = new PackageShareSessionImpl(this, ctx, UUID.randomUUID().toString());
            ctx.setSessionId(s.getId());
            Map<String, PackageShareSession> map = this.pool;
            synchronized (map) {
                this.pool.put(s.getId(), s);
            }
        }
        return s;
    }

    protected void discardSession(String id) {
    }

    protected Proxy createProxy(ClientContext ctx) {
        ProxyImpl p = new ProxyImpl(this.httpClient);
        p.setIdString(this.getIdString(ctx));
        p.setRewritePath(this.defaultRewritePath);
        p.setSpoolPath(this.defaultSpoolPath);
        return p;
    }

    public PackageShareSession login(ClientContext ctx, String user, String pass) throws IOException {
        Proxy p = this.createProxy(ctx);
        UsernamePasswordCredentials creds = null;
        if (user == null || user.length() == 0) {
            user = "anonymous";
        } else {
            creds = new UsernamePasswordCredentials(user, pass);
            p.setCredentials((Credentials)creds);
        }
        p.setFollowRedirects(true);
        try {
            JSONObject json;
            int status = p.doGet(SHARE_LOGIN_PATH);
            if (status != 200) {
                log.info("PackageShare login for {} failed: {}", (Object)user, (Object)status);
                PackageShareSession packageShareSession = null;
                return packageShareSession;
            }
            String data = p.fetch();
            try {
                json = new JSONObject(data);
            }
            catch (JSONException e) {
                log.info("PackageShare login for {} failed: JSONException", (Object)user);
                PackageShareSession packageShareSession = null;
                p.close();
                return packageShareSession;
            }
            PackageShareSessionImpl s = (PackageShareSessionImpl)this.getSession(ctx);
            s.setUser(user, (Credentials)creds, json);
            log.info("PackageShare login of {} successfull.", (Object)user);
            PackageShareSessionImpl packageShareSessionImpl = s;
            return packageShareSessionImpl;
        }
        catch (IOException io) {
            log.info("PackageShare login for {} failed: {}", (Object)user, (Object)io.toString());
            throw io;
        }
        finally {
            p.close();
        }
    }
}

