/*
 * Decompiled with CFR 0.152.
 */
package com.day.packageshare.client.impl;

import com.day.commons.org.json.JSONArray;
import com.day.commons.org.json.JSONException;
import com.day.commons.org.json.JSONObject;
import com.day.packageshare.client.ClientContext;
import com.day.packageshare.client.HtmlStatusResponseParser;
import com.day.packageshare.client.JSONResponse;
import com.day.packageshare.client.PackageInfo;
import com.day.packageshare.client.PackageShare;
import com.day.packageshare.client.PackageShareSession;
import com.day.packageshare.client.Proxy;
import com.day.packageshare.client.ProxyTracker;
import com.day.packageshare.client.impl.PackageShareImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageShareSessionImpl
implements PackageShareSession {
    private final PackageShareImpl svc;
    private final String id;
    private final ClientContext ctx;
    private final long creationTime;
    private Data data;
    private Credentials creds;

    protected PackageShareSessionImpl(PackageShareImpl svc, ClientContext ctx, String id) {
        this.svc = svc;
        this.id = id;
        this.ctx = ctx;
        this.creationTime = System.currentTimeMillis();
    }

    public void setUser(String userId, Credentials creds, JSONObject data) {
        this.creds = creds;
        this.data = new Data(userId, data);
    }

    @Override
    public boolean isNew() {
        return this.data == null;
    }

    @Override
    public boolean isAnonymous() {
        return this.creds == null;
    }

    @Override
    public PackageShare getService() {
        return this.svc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getUserId() {
        return this.data == null ? "anonymous" : this.data.userId;
    }

    @Override
    public String getUserName() {
        if (this.data == null) {
            return null;
        }
        try {
            return this.data.data.getJSONObject("user").optString("name");
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public Set<String> getSharedGroups() {
        return this.data == null ? null : this.data.getSharedGroups();
    }

    @Override
    public JSONObject getSessionInfo() {
        return this.data == null ? null : this.data.data;
    }

    @Override
    public Set<PackageInfo> getAvailablePackages() {
        return null;
    }

    @Override
    public void logout() {
        this.data = null;
        this.creds = null;
        this.svc.discardSession(this.id);
    }

    @Override
    public Proxy createProxy() {
        Proxy p = this.svc.createProxy(this.ctx);
        if (this.creds != null) {
            p.setCredentials(this.creds);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONResponse uploadPackage(File file, String fileName, ProxyTracker tracker, String group) throws IOException {
        Proxy proxy = this.createProxy();
        proxy.setTracker(tracker);
        proxy.addExtraFile("file", file, fileName == null ? "unknown" : fileName);
        proxy.addExtraParameter("cmd", "promote");
        if (group != null && group.length() > 0) {
            proxy.addExtraParameter("group", group);
        }
        try {
            int status = proxy.doPost("/apps/packageshare/content/service.html");
            String data = proxy.fetch();
            try {
                JSONResponse jSONResponse = HtmlStatusResponseParser.parse(data);
                return jSONResponse;
            }
            catch (IOException e) {
                JSONResponse r = new JSONResponse(false, "Unknown Error");
                r.setStatus(status);
                JSONResponse jSONResponse = r;
                proxy.close();
                return jSONResponse;
            }
        }
        finally {
            proxy.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Data {
        private final String userId;
        private final JSONObject data;
        private Set<String> shares;

        private Data(String userId, JSONObject data) {
            this.userId = userId;
            this.data = data;
        }

        public Set<String> getSharedGroups() {
            if (this.shares == null) {
                this.shares = new HashSet<String>();
                try {
                    JSONArray names = this.data.getJSONObject("shares").names();
                    for (int i = 0; i < names.length(); ++i) {
                        this.shares.add(names.getString(i));
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return this.shares;
        }
    }
}

